/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.User;
import hudson.remoting.Base64;
import hudson.tasks.Mailer;
import io.jenkins.blueocean.auth.jwt.JwkService;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationService;
import io.jenkins.blueocean.auth.jwt.JwtToken;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class JwtImpl
extends JwtAuthenticationService {
    private static int DEFAULT_EXPIRY_IN_SEC = 1800;
    private static int DEFAULT_MAX_EXPIRY_TIME_IN_MIN = 480;
    private static int DEFAULT_NOT_BEFORE_IN_SEC = 30;

    @Override
    public JwtToken getToken(@Nullable @QueryParameter(value="expiryTimeInMins") Integer expiryTimeInMins, @Nullable @QueryParameter(value="maxExpiryTimeInMins") Integer maxExpiryTimeInMins) {
        String t = System.getProperty("EXPIRY_TIME_IN_MINS");
        long expiryTime = DEFAULT_EXPIRY_IN_SEC;
        if (t != null) {
            expiryTime = Integer.parseInt(t);
        }
        int maxExpiryTime = DEFAULT_MAX_EXPIRY_TIME_IN_MIN;
        t = System.getProperty("MAX_EXPIRY_TIME_IN_MINS");
        if (t != null) {
            maxExpiryTime = Integer.parseInt(t);
        }
        if (maxExpiryTimeInMins != null) {
            maxExpiryTime = maxExpiryTimeInMins;
        }
        if (expiryTimeInMins != null) {
            if (expiryTimeInMins > maxExpiryTime) {
                throw new ServiceException.BadRequestExpception(String.format("expiryTimeInMins %s can't be greated than %s", expiryTimeInMins, maxExpiryTime));
            }
            expiryTime = expiryTimeInMins * 60;
        }
        Jenkins.getInstance();
        Authentication authentication = Jenkins.getAuthentication();
        if (authentication == null) {
            throw new ServiceException.UnauthorizedException("Unauthorized: No login session found");
        }
        String userId = authentication.getName();
        User user = User.get((String)userId, (boolean)false, Collections.emptyMap());
        String email = null;
        String fullName = null;
        if (user != null) {
            fullName = user.getFullName();
            userId = user.getId();
            Mailer.UserProperty p = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
            if (p != null) {
                email = p.getAddress();
            }
        }
        Plugin plugin = Jenkins.getInstance().getPlugin("blueocean-jwt");
        String issuer = "blueocean-jwt:" + (plugin != null ? plugin.getWrapper().getVersion() : "");
        JwtToken jwtToken = new JwtToken();
        jwtToken.claim.put("jti", (Object)UUID.randomUUID().toString().replace("-", ""));
        jwtToken.claim.put("iss", (Object)issuer);
        jwtToken.claim.put("sub", (Object)userId);
        jwtToken.claim.put("name", (Object)fullName);
        long currentTime = System.currentTimeMillis() / 1000L;
        jwtToken.claim.put("iat", (Object)currentTime);
        jwtToken.claim.put("exp", (Object)(currentTime + expiryTime));
        jwtToken.claim.put("nbf", (Object)(currentTime - (long)DEFAULT_NOT_BEFORE_IN_SEC));
        JSONObject context = new JSONObject();
        JSONObject userObject = new JSONObject();
        userObject.put("id", (Object)userId);
        userObject.put("fullName", (Object)fullName);
        userObject.put("email", (Object)email);
        context.put("user", (Object)userObject);
        jwtToken.claim.put("context", (Object)context);
        return jwtToken;
    }

    @Override
    public JwkFactory getJwks(String name) {
        if (name == null) {
            throw new ServiceException.BadRequestExpception("keyId is required");
        }
        return new JwkFactory(name);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "BlueOcean Jwt endpoint";
    }

    public class JwkFactory
    extends JwkService {
        private final String keyId;

        public JwkFactory(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public JSONObject getJwk() {
            JwtToken.JwtRsaDigitalSignatureKey key = new JwtToken.JwtRsaDigitalSignatureKey(this.keyId);
            try {
                if (!key.exists()) {
                    throw new ServiceException.NotFoundException(String.format("kid %s not found", this.keyId));
                }
            }
            catch (IOException e) {
                throw new ServiceException.UnexpectedErrorException("Unexpected error: " + e.getMessage(), (Throwable)e);
            }
            RSAPublicKey publicKey = key.getPublicKey();
            JSONObject jwk = new JSONObject();
            jwk.put("kty", (Object)"RSA");
            jwk.put("alg", (Object)"RS256");
            jwk.put("kid", (Object)this.keyId);
            jwk.put("use", (Object)"sig");
            jwk.put("key_ops", (Object)ImmutableList.of((Object)"verify"));
            jwk.put("n", (Object)Base64.encode((byte[])publicKey.getModulus().toByteArray()));
            jwk.put("e", (Object)Base64.encode((byte[])publicKey.getPublicExponent().toByteArray()));
            return jwk;
        }
    }
}

