/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt;

import io.jenkins.blueocean.auth.jwt.JwtTokenDecorator;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.security.Key;
import java.util.UUID;
import javax.servlet.ServletException;
import jenkins.security.RSADigitalSignatureConfidentialKey;
import net.sf.json.JSONObject;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtToken
implements HttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(JwtToken.class);
    public static final String X_BLUEOCEAN_JWT = "X-BLUEOCEAN-JWT";
    private static final String DEFAULT_KEY_ID = UUID.randomUUID().toString().replace("-", "");
    public final JSONObject header = new JSONObject();
    public final JSONObject claim = new JSONObject();

    public String sign() {
        for (JwtTokenDecorator decorator : JwtTokenDecorator.all()) {
            decorator.decorate(this);
        }
        String keyId = (String)this.header.get("kid");
        if (keyId == null) {
            keyId = DEFAULT_KEY_ID;
        }
        JwtRsaDigitalSignatureKey rsaDigitalSignatureConfidentialKey = new JwtRsaDigitalSignatureKey(keyId);
        try {
            return rsaDigitalSignatureConfidentialKey.sign(this.claim);
        }
        catch (JoseException e) {
            String msg = "Failed to sign JWT token: " + e.getMessage();
            logger.error(msg);
            throw new ServiceException.UnexpectedErrorException(msg, (Throwable)e);
        }
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        rsp.setStatus(200);
        rsp.addHeader(X_BLUEOCEAN_JWT, this.sign());
    }

    public static final class JwtRsaDigitalSignatureKey
    extends RSADigitalSignatureConfidentialKey {
        private final String id;

        public JwtRsaDigitalSignatureKey(String id) {
            super("blueoceanJwt-" + id);
            this.id = id;
        }

        public String sign(JSONObject claim) throws JoseException {
            JsonWebSignature jsonWebSignature = new JsonWebSignature();
            jsonWebSignature.setPayload(claim.toString());
            jsonWebSignature.setKey((Key)this.getPrivateKey());
            jsonWebSignature.setKeyIdHeaderValue(this.id);
            jsonWebSignature.setAlgorithmHeaderValue("RS256");
            jsonWebSignature.setHeader("typ", "JWT");
            return jsonWebSignature.getCompactSerialization();
        }

        public boolean exists() throws IOException {
            return super.load() != null;
        }
    }
}

