/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.jira;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import io.jenkins.blueocean.service.embedded.jira.BlueJiraIssue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Extension
public class JiraSCMListener
extends SCMListener {
    public void onChangeLogParsed(Run<?, ?> run, SCM scm, TaskListener listener, ChangeLogSet<?> changelog) throws Exception {
        JiraSite jiraSite = JiraSite.get((Job)run.getParent());
        if (jiraSite == null) {
            return;
        }
        ArrayList issueKeys = Lists.newArrayList();
        for (ChangeLogSet.Entry entry : changelog) {
            issueKeys.addAll(BlueJiraIssue.findIssueKeys(entry.getMsg(), jiraSite.getIssuePattern()));
        }
        if (issueKeys.isEmpty()) {
            return;
        }
        String jql = JiraSCMListener.constructJQLQuery(issueKeys);
        JiraSession session = jiraSite.getSession();
        if (session == null) {
            return;
        }
        HashSet issuesFromJqlSearch = Sets.newHashSet((Iterable)Iterables.transform((Iterable)session.getIssuesFromJqlSearch(jql), (Function)new Function<Issue, JiraIssue>(){

            public JiraIssue apply(Issue input) {
                return new JiraIssue(input);
            }
        }));
        if (issuesFromJqlSearch.isEmpty()) {
            return;
        }
        JiraBuildAction action = (JiraBuildAction)run.getAction(JiraBuildAction.class);
        if (action == null) {
            run.addAction((Action)new JiraBuildAction(run, (Set)issuesFromJqlSearch));
        } else {
            action.addIssues((Set)issuesFromJqlSearch);
        }
        run.save();
    }

    static String constructJQLQuery(List<String> issueKeys) {
        StringBuilder jql = new StringBuilder();
        jql.append("key in (");
        for (int i = 0; i < issueKeys.size(); ++i) {
            jql.append("'");
            jql.append(issueKeys.get(i));
            jql.append("'");
            if (issueKeys.size() <= 1 || i + 1 >= issueKeys.size()) continue;
            jql.append(",");
        }
        jql.append(")");
        return jql.toString();
    }
}

