/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.jira;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraJobAction;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.factory.BlueIssueFactory;
import io.jenkins.blueocean.rest.model.BlueIssue;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class BlueJiraIssue
extends BlueIssue {
    private static final Logger LOGGER = Logger.getLogger(BlueJiraIssue.class.getName());
    private final String issueKey;
    private final String issueURL;

    public BlueJiraIssue(String issueKey, String issueURL) {
        this.issueKey = issueKey;
        this.issueURL = issueURL;
    }

    public String getId() {
        return this.issueKey;
    }

    public String getURL() {
        return this.issueURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BlueJiraIssue that = (BlueJiraIssue)((Object)o);
        return Objects.equal((Object)this.issueKey, (Object)that.issueKey) && Objects.equal((Object)this.issueURL, (Object)that.issueURL);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.issueKey, this.issueURL});
    }

    static Collection<String> findIssueKeys(String input, Pattern pattern) {
        Matcher m = pattern.matcher(input);
        HashSet issues = Sets.newHashSet();
        while (m.find()) {
            if (m.groupCount() < 1) continue;
            String id = m.group(1);
            issues.add(id);
        }
        return issues;
    }

    @CheckForNull
    static BlueIssue create(@Nonnull JiraSite site, @Nullable JiraIssue issue) {
        if (issue == null) {
            return null;
        }
        try {
            return new BlueJiraIssue(issue.getKey(), site.getUrl(issue).toString());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Extension
    public static class FactoryImpl
    extends BlueIssueFactory {
        public Collection<BlueIssue> getIssues(Job job) {
            JiraSite jiraSite = JiraSite.get((Job)job);
            if (jiraSite == null) {
                return null;
            }
            JiraJobAction action = (JiraJobAction)job.getAction(JiraJobAction.class);
            if (action == null) {
                return null;
            }
            BlueIssue issue = BlueJiraIssue.create(jiraSite, action.getIssue());
            if (issue == null) {
                return null;
            }
            return ImmutableList.of((Object)issue);
        }

        public Collection<BlueIssue> getIssues(ChangeLogSet.Entry changeSetEntry) {
            Run run = changeSetEntry.getParent().getRun();
            final JiraSite site = JiraSite.get((Job)run.getParent());
            if (site == null) {
                return null;
            }
            final JiraBuildAction action = (JiraBuildAction)run.getAction(JiraBuildAction.class);
            if (action == null) {
                return null;
            }
            Collection<String> issueKeys = BlueJiraIssue.findIssueKeys(changeSetEntry.getMsg(), site.getIssuePattern());
            Iterable transformed = Iterables.transform(issueKeys, (Function)new Function<String, BlueIssue>(){

                public BlueIssue apply(String input) {
                    return BlueJiraIssue.create(site, action.getIssue(input));
                }
            });
            return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)transformed, (Predicate)Predicates.notNull()));
        }
    }
}

