/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.i18n;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.util.HttpResponses;
import io.jenkins.blueocean.rest.ApiRoutable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public class BlueI18n
implements ApiRoutable {
    private static final Logger LOGGER = Logger.getLogger(BlueI18n.class.getName());
    private static final JSONObject BUNDLE_404 = new JSONObject();
    private Map<BundleParams, BundleCacheEntry> bundleCache = new ConcurrentHashMap<BundleParams, BundleCacheEntry>();

    public String getUrlName() {
        return "i18n";
    }

    public HttpResponse doDynamic(StaplerRequest request) {
        String path = request.getOriginalRequestURI();
        String contextPath = request.getContextPath();
        BundleParams bundleParams = BlueI18n.getBundleParameters(path = path.substring(contextPath.length()));
        if (bundleParams == null) {
            return HttpResponses.errorJSON((String)"All mandatory bundle identification parameters not specified: '$PLUGIN_NAME/$PLUGIN_VERSION/$BUNDLE_NAME' (and optional $LOCALE).");
        }
        try {
            BundleCacheEntry bundleCacheEntry;
            Locale locale = bundleParams.getLocale();
            if (locale == null) {
                locale = request.getLocale();
            }
            if ((bundleCacheEntry = this.bundleCache.get(bundleParams)) == null) {
                JSONObject bundle = this.getBundle(bundleParams, locale);
                if (bundle == null) {
                    bundle = BUNDLE_404;
                }
                bundleCacheEntry = new BundleCacheEntry(bundle, bundleParams);
                this.bundleCache.put(bundleParams, bundleCacheEntry);
            }
            if (bundleCacheEntry.bundleData == BUNDLE_404) {
                return JSONObjectResponse.errorJson("Unknown plugin or resource bundle: " + bundleParams.toString(), 404);
            }
            return JSONObjectResponse.okJson(bundleCacheEntry);
        }
        catch (Exception e) {
            return HttpResponses.errorJSON((String)e.getMessage());
        }
    }

    @CheckForNull
    private JSONObject getBundle(BundleParams bundleParams, Locale locale) {
        PluginWrapper plugin = bundleParams.getPlugin();
        if (plugin == null) {
            return null;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleParams.bundleName, locale, plugin.classLoader);
            JSONObject bundleJSON = new JSONObject();
            for (String key : resourceBundle.keySet()) {
                bundleJSON.put(key, (Object)resourceBundle.getString(key));
            }
            return bundleJSON;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @CheckForNull
    static BundleParams getBundleParameters(String restOfPath) {
        if (restOfPath == null || restOfPath.length() == 0) {
            return null;
        }
        String[] pathTokens = restOfPath.split("/");
        ArrayList<String> bundleParameters = new ArrayList<String>();
        for (String pathToken : pathTokens) {
            if (pathToken.length() <= 0) continue;
            bundleParameters.add(BlueI18n.urlDecode(pathToken));
        }
        if (((String)bundleParameters.get(0)).equals("blue")) {
            bundleParameters.remove(0);
        }
        if (((String)bundleParameters.get(0)).equals("rest")) {
            bundleParameters.remove(0);
        }
        if (((String)bundleParameters.get(0)).equals("i18n")) {
            bundleParameters.remove(0);
        }
        if (bundleParameters.size() != 3 && bundleParameters.size() != 4) {
            return null;
        }
        BundleParams bundleParams = new BundleParams((String)bundleParameters.get(0), (String)bundleParameters.get(1), (String)bundleParameters.get(2));
        if (bundleParameters.size() == 4) {
            String locale = (String)bundleParameters.get(3);
            String[] localeTokens = locale.split("-|_");
            bundleParams.language = localeTokens[0];
            if (localeTokens.length > 1) {
                bundleParams.country = localeTokens[1];
                if (localeTokens.length > 2) {
                    bundleParams.variant = localeTokens[2];
                }
            }
        }
        return bundleParams;
    }

    @CheckForNull
    static PluginWrapper getPlugin(String pluginName) {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins.getPluginManager().getPlugin(pluginName);
    }

    @Nonnull
    private static String urlDecode(@Nonnull String pathToken) {
        try {
            return URLDecoder.decode(pathToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected URL decode exception. UTF-8 not supported on this system.", e);
        }
    }

    static class JSONObjectResponse
    implements HttpResponse {
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private final JSONObject jsonObject = new JSONObject();
        private BundleCacheEntry bundleCacheEntry;
        private int statusCode = 200;

        JSONObjectResponse() {
        }

        private static JSONObjectResponse okJson(BundleCacheEntry bundleCacheEntry) {
            JSONObjectResponse response = new JSONObjectResponse();
            response.bundleCacheEntry = bundleCacheEntry;
            response.jsonObject.put("data", (Object)bundleCacheEntry.bundleData);
            response.jsonObject.put("status", (Object)"ok");
            response.jsonObject.put("cache-timestamp", (Object)bundleCacheEntry.timestamp);
            return response;
        }

        private static JSONObjectResponse errorJson(String message, int errorCode) {
            JSONObjectResponse response = new JSONObjectResponse();
            response.jsonObject.put("status", (Object)"error");
            response.jsonObject.put("message", (Object)message);
            response.statusCode = errorCode;
            return response;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            rsp.setStatus(this.statusCode);
            rsp.setContentType("application/json; charset=UTF-8");
            if (this.bundleCacheEntry != null) {
                this.jsonObject.put("plugin-version-requested", (Object)((BundleCacheEntry)this.bundleCacheEntry).bundleParams.pluginVersion);
                PluginWrapper pluginWrapper = this.bundleCacheEntry.bundleParams.getPlugin();
                if (pluginWrapper != null) {
                    this.jsonObject.put("plugin-version-actual", (Object)pluginWrapper.getVersion());
                }
                if (this.bundleCacheEntry.bundleParams.isBrowserCacheable()) {
                    rsp.setHeader("Cache-Control", "public, max-age=31536000");
                } else if (!this.bundleCacheEntry.bundleParams.isMatchingPluginVersionInstalled()) {
                    LOGGER.log(Level.WARNING, String.format("Unexpected request for Blue Ocean i18n resource bundle '%s'. Installed plugin version '%s' does not match.", this.bundleCacheEntry.bundleParams, pluginWrapper != null ? pluginWrapper.getVersion() : "unknown"));
                }
            }
            byte[] bytes = this.jsonObject.toString().getBytes(UTF8);
            rsp.setContentLength(bytes.length);
            rsp.getOutputStream().write(bytes);
        }
    }

    private static class BundleCacheEntry {
        private final JSONObject bundleData;
        private final BundleParams bundleParams;
        private final long timestamp = System.currentTimeMillis();

        public BundleCacheEntry(JSONObject bundleData, BundleParams bundleParams) {
            this.bundleData = bundleData;
            this.bundleParams = bundleParams;
        }
    }

    static class BundleParams {
        final String pluginName;
        final String pluginVersion;
        final String bundleName;
        String language;
        String country;
        String variant;
        private PluginWrapper plugin;
        private static Pattern RELEASE_VERSION_PATTERN = Pattern.compile("[\\d/.]{3,}");

        BundleParams(String pluginName, String pluginVersion, String bundleName) {
            this.pluginName = pluginName;
            this.pluginVersion = pluginVersion;
            this.bundleName = bundleName;
        }

        @CheckForNull
        Locale getLocale() {
            if (this.language != null && this.country != null && this.variant != null) {
                return new Locale(this.language, this.country, this.variant);
            }
            if (this.language != null && this.country != null) {
                return new Locale(this.language, this.country);
            }
            if (this.language != null) {
                return new Locale(this.language);
            }
            return null;
        }

        boolean isReleaseVersion(String version) {
            return RELEASE_VERSION_PATTERN.matcher(version).matches();
        }

        boolean isReleaseVersion() {
            return this.isReleaseVersion(this.pluginVersion);
        }

        @CheckForNull
        PluginWrapper getPlugin() {
            if (this.plugin != null) {
                return this.plugin;
            }
            this.plugin = BlueI18n.getPlugin(this.pluginName);
            return this.plugin;
        }

        boolean isMatchingPluginVersionInstalled() {
            PluginWrapper plugin = this.getPlugin();
            return plugin != null && plugin.getVersion().equals(this.pluginVersion);
        }

        boolean isBrowserCacheable() {
            return this.isReleaseVersion() && this.isMatchingPluginVersionInstalled();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BundleParams that = (BundleParams)o;
            if (!this.pluginName.equals(that.pluginName)) {
                return false;
            }
            if (!this.pluginVersion.equals(that.pluginVersion)) {
                return false;
            }
            if (!this.bundleName.equals(that.bundleName)) {
                return false;
            }
            if (this.language != null ? !this.language.equals(that.language) : that.language != null) {
                return false;
            }
            if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
                return false;
            }
            return this.variant != null ? this.variant.equals(that.variant) : that.variant == null;
        }

        public int hashCode() {
            int result = this.pluginName.hashCode();
            result = 31 * result + this.pluginVersion.hashCode();
            result = 31 * result + this.bundleName.hashCode();
            result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
            result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
            result = 31 * result + (this.variant != null ? this.variant.hashCode() : 0);
            return result;
        }

        public String toString() {
            String string = this.pluginName + "/" + this.pluginVersion + "/" + this.bundleName;
            Locale locale = this.getLocale();
            if (locale != null) {
                string = string + "/" + locale.toString();
            }
            return string;
        }
    }
}

