/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubCredentialUtils;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.scm.api.AbstractMultiBranchCreateRequest;
import io.jenkins.blueocean.scm.api.AbstractScmSourceEvent;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.BranchDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceBuilder;
import org.kohsuke.stapler.DataBoundConstructor;

public class GithubPipelineCreateRequest
extends AbstractMultiBranchCreateRequest {
    @DataBoundConstructor
    public GithubPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        super(name, scmConfig);
    }

    protected SCMSource createSource(@Nonnull MultiBranchProject project, @Nonnull BlueScmConfig scmConfig) {
        if (scmConfig.getId().equals("github-enterprise")) {
            this.updateEndpoints(scmConfig.getUri());
        }
        return ((GitHubSCMSourceBuilder)new GitHubSCMSourceBuilder(null, scmConfig.getUri(), this.computeCredentialId(scmConfig), (String)scmConfig.getConfig().get("repoOwner"), (String)scmConfig.getConfig().get("repository")).withTrait((SCMSourceTrait)new BranchDiscoveryTrait(3))).build();
    }

    @Nullable
    protected AbstractScmSourceEvent getScmSourceEvent(final @Nonnull MultiBranchProject project, @Nonnull SCMSource source) {
        if (source instanceof GitHubSCMSource) {
            return new AbstractScmSourceEvent(((GitHubSCMSource)source).getRepository(), ((GitHubSCMSource)source).getApiUri()){

                public boolean isMatch(@NonNull SCMSource source) {
                    SCMSourceOwner sourceOwner = source.getOwner();
                    return ((GitHubSCMSource)source).getRepository().equals(this.getSourceName()) && sourceOwner != null && sourceOwner.getFullName().equals(project.getFullName());
                }
            };
        }
        return null;
    }

    protected List<ErrorMessage.Error> validate(String name, BlueScmConfig scmConfig) {
        ArrayList errors = Lists.newArrayList();
        StandardUsernamePasswordCredentials credentials = null;
        String credentialId = this.computeCredentialIdWithGithubDefault(scmConfig);
        if (StringUtils.isBlank((CharSequence)scmConfig.getUri())) {
            errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "uri is required"));
        }
        if (credentialId != null) {
            credentials = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        }
        if (credentials == null) {
            errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.NOT_FOUND.toString(), "No Credentials instance found for credentialId: " + credentialId));
        } else if (StringUtils.isNotBlank((CharSequence)scmConfig.getUri())) {
            String accessToken = credentials.getPassword().getPlainText();
            try {
                GithubPipelineCreateRequest.validateGithubAccessToken(accessToken, scmConfig.getUri());
            }
            catch (IOException e) {
                throw new ServiceException.UnexpectedErrorException(e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)((String)scmConfig.getConfig().get("repoOwner")))) {
            errors.add(new ErrorMessage.Error("scmConfig.repoOwner", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "repoOwner is required"));
        }
        if (StringUtils.isBlank((CharSequence)((String)scmConfig.getConfig().get("repository")))) {
            errors.add(new ErrorMessage.Error("scmConfig.repository", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "repository is required"));
        }
        return errors;
    }

    protected String computeCredentialId(BlueScmConfig scmConfig) {
        return GithubCredentialUtils.computeCredentialId(scmConfig.getCredentialId(), scmConfig.getId(), scmConfig.getUri());
    }

    private String computeCredentialIdWithGithubDefault(BlueScmConfig blueScmConfig) {
        if (StringUtils.isBlank((CharSequence)blueScmConfig.getId())) {
            return "github";
        }
        return this.computeCredentialId(blueScmConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEndpoints(String apiUrl) {
        GitHubConfiguration config;
        GitHubConfiguration gitHubConfiguration = config = GitHubConfiguration.get();
        synchronized (gitHubConfiguration) {
            final String finalApiUrl = apiUrl;
            Endpoint endpoint = (Endpoint)Iterables.find((Iterable)config.getEndpoints(), (Predicate)new Predicate<Endpoint>(){

                public boolean apply(@Nullable Endpoint input) {
                    return input != null && input.getApiUri().equals(finalApiUrl);
                }
            }, null);
            if (endpoint == null) {
                config.setEndpoints((List)ImmutableList.of((Object)new Endpoint(apiUrl, apiUrl)));
                config.save();
            }
        }
    }

    private static void validateGithubAccessToken(String accessToken, String apiUrl) throws IOException {
        try {
            String cleanApiUrl = apiUrl.endsWith("/") ? apiUrl.substring(0, apiUrl.length() - 1) : apiUrl;
            HttpURLConnection connection = GithubScm.connect(cleanApiUrl + "/user", accessToken);
            GithubScm.validateAccessTokenScopes(connection);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw e;
            }
            throw new ServiceException.UnexpectedErrorException("Failure validating github access token: " + e.getMessage(), (Throwable)e);
        }
    }
}

