/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import hudson.model.TopLevelItem;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMNavigator;
import org.apache.http.client.utils.URIBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;

public abstract class AbstractGithubOrganization
extends ScmOrganization {
    private static final Logger LOGGER = Logger.getLogger(AbstractGithubOrganization.class.getName());
    private static final int AVATAR_SIZE = 50;

    public boolean isJenkinsOrganizationPipeline() {
        for (TopLevelItem item : Jenkins.get().getItems()) {
            if (!(item instanceof OrganizationFolder)) continue;
            OrganizationFolder folder = (OrganizationFolder)item;
            for (SCMNavigator navigator : folder.getNavigators()) {
                GitHubSCMNavigator scmNavigator;
                if (!(navigator instanceof GitHubSCMNavigator) || !(scmNavigator = (GitHubSCMNavigator)navigator).getRepoOwner().equals(this.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected static String getAvatarWithSize(@Nonnull String avatarUrl) {
        try {
            return new URIBuilder(avatarUrl).addParameter("s", Integer.toString(50)).build().toString();
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Could not parse avatar URL <" + avatarUrl + ">", e);
            return null;
        }
    }
}

