/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubRepositories;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubRepository;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositories;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepository;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositoryContainer;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GHRepository;

public class GithubRespositoryContainer
extends ScmRepositoryContainer {
    private final Link self;
    private final StandardUsernamePasswordCredentials credentials;
    private final String rootUrl;
    private final String orgId;
    private final String orgUrl;

    public GithubRespositoryContainer(Scm scm, String orgUrl, String orgId, StandardUsernamePasswordCredentials credentials, Reachable parent) {
        this.rootUrl = scm.getUri();
        this.self = parent.getLink().rel("repositories");
        this.credentials = credentials;
        this.orgId = orgId;
        this.orgUrl = orgUrl;
    }

    public Link getLink() {
        return this.self;
    }

    public ScmRepositories getRepositories() {
        return new GithubRepositories(this.credentials, this.orgUrl, (Reachable)this);
    }

    public ScmRepository get(String name) {
        try {
            HttpURLConnection connection = GithubScm.connect(String.format("%s/repos/%s/%s", this.rootUrl, this.orgId, name), this.credentials.getPassword().getPlainText());
            GHRepository repository = (GHRepository)JsonConverter.toJava((String)IOUtils.toString((InputStream)connection.getInputStream()), GHRepository.class);
            return new GithubRepository(repository, this.credentials, (Reachable)this);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }
}

