/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.collect.ImmutableMap;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepository;
import java.util.Map;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.export.Exported;

public class GithubRepository
extends ScmRepository {
    private final GHRepository ghRepository;
    private final StandardUsernamePasswordCredentials credentials;
    private final Link self;

    public GithubRepository(GHRepository ghRepository, StandardUsernamePasswordCredentials credentials, Reachable parent) {
        this.ghRepository = ghRepository;
        this.credentials = credentials;
        this.self = parent.getLink().rel(ghRepository.getName());
    }

    public String getName() {
        return this.ghRepository.getName();
    }

    @Exported
    public String getFullName() {
        return this.ghRepository.getFullName();
    }

    public boolean isPrivate() {
        return this.ghRepository.isPrivate();
    }

    public String getDescription() {
        return this.ghRepository.getDescription();
    }

    public String getDefaultBranch() {
        return this.ghRepository.getDefaultBranch();
    }

    public Map<String, Boolean> getPermissions() {
        return ImmutableMap.of((Object)"admin", (Object)this.ghRepository.hasAdminAccess(), (Object)"push", (Object)this.ghRepository.hasPushAccess(), (Object)"pull", (Object)this.ghRepository.hasPullAccess());
    }

    public Link getLink() {
        return this.self;
    }
}

