/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubRepository;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositories;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class GithubRepositories
extends ScmRepositories {
    private final Link self;
    private final GHRepository[] repositories;
    private final String accessToken;
    private final Integer nextPage;
    private final Integer lastPage;
    private final int pageSize;
    private final StandardUsernamePasswordCredentials credential;

    public GithubRepositories(StandardUsernamePasswordCredentials credentials, String orgUrl, Reachable parent) {
        this.self = parent.getLink().rel("repositories");
        this.accessToken = credentials.getPassword().getPlainText();
        this.credential = credentials;
        StaplerRequest request = Stapler.getCurrentRequest();
        int pageNumber = 0;
        if (request.getParameter("pageNumber") != null) {
            pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        }
        int pageSize = 0;
        if (request.getParameter("pageSize") != null) {
            pageSize = Integer.parseInt(request.getParameter("pageSize"));
        }
        try {
            if (pageNumber == 0) {
                pageNumber = 1;
            }
            if (pageSize == 0) {
                pageSize = 100;
            }
            HttpURLConnection connection = null;
            connection = GithubScm.connect(String.format("%s/repos?per_page=%s&page=%s", orgUrl, pageSize, pageNumber), this.accessToken);
            this.repositories = (GHRepository[])JsonConverter.toJava((String)IOUtils.toString((InputStream)connection.getInputStream()), GHRepository[].class);
            String link = connection.getHeaderField("Link");
            int nextPage = 0;
            int lastPage = 0;
            if (link != null) {
                for (String token : link.split(", ")) {
                    if (!token.endsWith("rel=\"next\"") && !token.endsWith("rel=\"last\"")) continue;
                    int idx = token.indexOf(62);
                    URL url = new URL(token.substring(1, idx));
                    for (String q : url.getQuery().split("&")) {
                        if (!q.trim().startsWith("page=")) continue;
                        int i = q.indexOf(61);
                        if (q.length() < i + 1) continue;
                        if (token.endsWith("rel=\"next\"")) {
                            nextPage = Integer.parseInt(q.substring(i + 1));
                        }
                        if (!token.endsWith("rel=\"last\"")) continue;
                        lastPage = Integer.parseInt(q.substring(i + 1));
                    }
                }
            }
            this.nextPage = nextPage > 0 ? Integer.valueOf(nextPage) : null;
            this.lastPage = lastPage > 0 ? Integer.valueOf(lastPage) : null;
            this.pageSize = pageSize;
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Link getLink() {
        return this.self;
    }

    public Iterable<ScmRepository> getItems() {
        return Lists.transform(Arrays.asList(this.repositories), (Function)new Function<GHRepository, ScmRepository>(){

            public ScmRepository apply(@Nullable GHRepository input) {
                return new GithubRepository(input, GithubRepositories.this.credential, (Reachable)GithubRepositories.this);
            }
        });
    }

    @Exported
    public Integer getNextPage() {
        return this.nextPage;
    }

    @Exported
    public Integer getLastPage() {
        return this.lastPage;
    }

    @Exported
    public Integer getPageSize() {
        return this.pageSize;
    }
}

