/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.TopLevelItem;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubOrganizationFolder;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineCreateRequestImpl;
import java.io.IOException;
import java.util.List;
import jenkins.branch.CustomOrganizationFolderDescriptor;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.kohsuke.stapler.DataBoundConstructor;

public class GithubPipelineCreateRequest
extends AbstractPipelineCreateRequestImpl {
    private static final String DESCRIPTOR = "jenkins.branch.OrganizationFolder.org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator";
    private BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GithubPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.setName(name);
        this.scmConfig = scmConfig;
    }

    public BluePipeline create(Reachable parent) throws IOException {
        TopLevelItem item;
        String apiUrl = null;
        String orgName = this.getName();
        String credentialId = null;
        StringBuilder sb = new StringBuilder();
        if (this.scmConfig != null) {
            apiUrl = this.scmConfig.getUri();
            if (this.scmConfig.getConfig().get("orgName") instanceof String) {
                orgName = (String)this.scmConfig.getConfig().get("orgName");
            }
            credentialId = this.scmConfig.getCredentialId();
            if (this.scmConfig != null && this.scmConfig.getConfig().get("repos") instanceof List) {
                for (String r : (List)this.scmConfig.getConfig().get("repos")) {
                    sb.append(String.format("(%s\\b)?", r));
                }
            }
        }
        if ((item = this.create((ModifiableTopLevelItemGroup)Jenkins.getInstance(), this.getName(), DESCRIPTOR, CustomOrganizationFolderDescriptor.class)) instanceof OrganizationFolder) {
            GitHubSCMNavigator gitHubSCMNavigator = new GitHubSCMNavigator(apiUrl, orgName, credentialId, credentialId);
            if (sb.length() > 0) {
                gitHubSCMNavigator.setPattern(sb.toString());
            }
            GithubPipelineCreateRequest.validateCredentialId(credentialId, (OrganizationFolder)item, gitHubSCMNavigator);
            OrganizationFolder organizationFolder = (OrganizationFolder)item;
            organizationFolder.getNavigators().replace((Describable)gitHubSCMNavigator);
            organizationFolder.scheduleBuild((Cause)new Cause.UserIdCause());
            return new GithubOrganizationFolder(organizationFolder, parent.getLink());
        }
        return null;
    }

    static void validateCredentialId(String credentialId, OrganizationFolder item, GitHubSCMNavigator navigator) throws IOException {
        StandardCredentials credentials;
        if (credentialId != null && !credentialId.trim().isEmpty() && (credentials = Connector.lookupScanCredentials((SCMSourceOwner)item, (String)navigator.getApiUri(), (String)credentialId)) == null) {
            try {
                item.delete();
            }
            catch (InterruptedException e) {
                throw new ServiceException.UnexpectedErrorException("Invalid credentialId: " + credentialId + ". Failure during cleaing up folder: " + item.getName() + ". Error: " + e.getMessage(), (Throwable)e);
            }
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline").add(new ErrorMessage.Error("credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "Invalid credentialId")));
        }
    }
}

