/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.util.LogTaskListener;
import io.jenkins.blueocean.blueocean_git_pipeline.GitReadSaveRequest;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

class GitCloneReadSaveRequest
extends GitReadSaveRequest {
    private final File repositoryPath;
    private final GitTool gitTool;

    public GitCloneReadSaveRequest(AbstractGitSCMSource gitSource, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents) {
        super(gitSource, branch, commitMessage, sourceBranch, filePath, contents);
        GitTool.DescriptorImpl toolDesc = (GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class);
        GitTool foundGitTool = null;
        for (SCMSourceTrait trait : gitSource.getTraits()) {
            if (!(trait instanceof GitToolSCMSourceTrait)) continue;
            foundGitTool = toolDesc.getInstallation(((GitToolSCMSourceTrait)trait).getGitTool());
        }
        if (foundGitTool == null) {
            foundGitTool = GitTool.getDefaultInstallation();
        }
        this.gitTool = foundGitTool;
        try {
            this.repositoryPath = Files.createTempDirectory("git", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Unable to create working directory for repository clone");
        }
    }

    GitClient cloneRepo() throws InterruptedException, IOException {
        EnvVars environment = new EnvVars();
        LogTaskListener taskListener = new LogTaskListener(Logger.getAnonymousLogger(), Level.ALL);
        String gitExe = this.gitTool.getGitExe();
        GitClient git = Git.with((TaskListener)taskListener, (EnvVars)environment).in(this.repositoryPath).using(gitExe).getClient();
        git.addCredentials(this.gitSource.getRemote(), this.getCredential());
        try {
            git.clone(this.gitSource.getRemote(), "origin", true, null);
            log.fine("Repository " + this.gitSource.getRemote() + " cloned to: " + this.repositoryPath.getCanonicalPath());
        }
        catch (GitException e) {
            boolean isEmptyRepo;
            block6: {
                isEmptyRepo = false;
                try {
                    if (git.getRemoteReferences(this.gitSource.getRemote(), null, true, false).isEmpty()) {
                        isEmptyRepo = true;
                    }
                }
                catch (GitException ge) {
                    if (!"unexpected ls-remote output ".equals(ge.getMessage())) break block6;
                    isEmptyRepo = true;
                }
            }
            if (isEmptyRepo) {
                git.init();
                git.addRemoteUrl("origin", this.gitSource.getRemote());
                log.fine("Repository " + this.gitSource.getRemote() + " not found, created new to: " + this.repositoryPath.getCanonicalPath());
            }
            throw e;
        }
        return git;
    }

    @Override
    byte[] read() throws IOException {
        try {
            GitClient git = this.cloneRepo();
            try {
                git.checkoutBranch(this.branch, "origin/" + this.branch);
            }
            catch (Exception e) {
                throw new RuntimeException("Branch not found: " + this.branch);
            }
            File f = new File(this.repositoryPath, this.filePath);
            if (f.canRead()) {
                byte[] byArray = FileUtils.readFileToByteArray((File)f);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (InterruptedException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to read " + this.filePath, (Throwable)ex);
        }
        finally {
            this.cleanupRepo();
        }
    }

    @Override
    void save() throws IOException {
        try {
            File f;
            GitClient git = this.cloneRepo();
            try {
                git.checkoutBranch(this.sourceBranch, "origin/" + this.sourceBranch);
            }
            catch (Exception e) {
                throw new RuntimeException("Branch not found: " + this.sourceBranch);
            }
            if (!this.sourceBranch.equals(this.branch)) {
                git.checkoutBranch(this.branch, "origin/" + this.sourceBranch);
            }
            if (!(f = new File(this.repositoryPath, this.filePath)).exists() || !Arrays.equals(FileUtils.readFileToByteArray((File)f), this.contents)) {
                FileUtils.writeByteArrayToFile((File)f, (byte[])this.contents);
                git.add(this.filePath);
                git.commit(this.commitMessage);
            }
            git.push().ref(this.branch).to(new URIish(this.gitSource.getRemote())).execute();
        }
        catch (GitException | InterruptedException | URISyntaxException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to save " + this.filePath, ex);
        }
        finally {
            this.cleanupRepo();
        }
    }

    void cleanupRepo() {
        try {
            FileUtils.deleteDirectory((File)this.repositoryPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

