/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.collect.Lists;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.scm.api.AbstractMultiBranchCreateRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.CleanAfterCheckoutTrait;
import jenkins.plugins.git.traits.CleanBeforeCheckoutTrait;
import jenkins.plugins.git.traits.LocalBranchTrait;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitPipelineCreateRequest
extends AbstractMultiBranchCreateRequest {
    @DataBoundConstructor
    public GitPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        super(name, scmConfig);
    }

    protected SCMSource createSource(@Nonnull MultiBranchProject project, @Nonnull BlueScmConfig scmConfig) {
        GitSCMSource gitSource = new GitSCMSource(StringUtils.defaultString((String)scmConfig.getUri()));
        gitSource.setCredentialsId(this.computeCredentialId(scmConfig));
        List traits = gitSource.getTraits();
        traits.add(new BranchDiscoveryTrait());
        traits.add(new CleanBeforeCheckoutTrait());
        traits.add(new CleanAfterCheckoutTrait());
        traits.add(new LocalBranchTrait());
        return gitSource;
    }

    protected List<ErrorMessage.Error> validate(String name, BlueScmConfig scmConfig) {
        ArrayList errors = Lists.newArrayList();
        if (scmConfig.getUri() == null) {
            errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "uri is required"));
        } else {
            StandardCredentials credentials = null;
            String credentialId = this.computeCredentialId(scmConfig);
            if (credentialId != null && (credentials = GitUtils.getCredentials((ItemGroup)Jenkins.getInstance(), scmConfig.getUri(), credentialId)) == null) {
                errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.NOT_FOUND.toString(), String.format("credentialId: %s not found", credentialId)));
            }
            if (credentialId == null || credentials != null) {
                errors.addAll(GitUtils.validateCredentials(scmConfig.getUri(), credentials));
            }
        }
        return errors;
    }

    protected boolean repoHasJenkinsFile(@Nonnull SCMSource scmSource) {
        return true;
    }

    protected String computeCredentialId(BlueScmConfig scmConfig) {
        return scmConfig.getCredentialId();
    }
}

