/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.util.HttpResponses;
import io.jenkins.blueocean.blueocean_git_pipeline.GitBareRepoReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMSourceOwner;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.json.JsonBody;

public class GitScm
extends AbstractScm {
    public static final String ID = "git";
    protected final Reachable parent;

    public GitScm(Reachable parent) {
        this.parent = parent;
    }

    public Link getLink() {
        return this.parent.getLink().rel(ID);
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Nonnull
    public String getUri() {
        return "";
    }

    public String getCredentialId() {
        return null;
    }

    public Container<ScmOrganization> getOrganizations() {
        return null;
    }

    public ScmServerEndpointContainer getServers() {
        return null;
    }

    public HttpResponse validateAndCreate(@JsonBody JSONObject request) {
        String repositoryUrl;
        AbstractGitSCMSource scmSource;
        boolean requirePush = request.has("requirePush");
        if (request.has("repositoryUrl")) {
            scmSource = null;
            repositoryUrl = request.getString("repositoryUrl");
        } else {
            try {
                String fullName = request.getJSONObject("pipeline").getString("fullName");
                SCMSourceOwner item = (SCMSourceOwner)Jenkins.getInstance().getItemByFullName(fullName, SCMSourceOwner.class);
                if (item == null) {
                    return HttpResponses.errorJSON((String)("No repository found for: " + fullName));
                }
                scmSource = (AbstractGitSCMSource)item.getSCMSources().iterator().next();
                repositoryUrl = scmSource.getRemote();
            }
            catch (JSONException e) {
                return HttpResponses.errorJSON((String)"No repositoryUrl or pipeline.fullName specified in request.");
            }
            catch (RuntimeException e) {
                return HttpResponses.errorWithoutStack((int)500, (String)e.getMessage());
            }
        }
        try {
            String credentialId = request.getString("credentialId");
            User user = User.current();
            if (user == null) {
                throw new ServiceException.UnauthorizedException("Not authenticated");
            }
            final StandardCredentials creds = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)Jenkins.getAuthentication(), (List)null), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialId)}));
            if (creds == null) {
                throw new ServiceException.NotFoundException("No credentials found for: " + credentialId);
            }
            if (requirePush) {
                String branch = request.getString("branch");
                new GitBareRepoReadSaveRequest(scmSource, branch, null, branch, null, null).invokeOnScm(new GitSCMFileSystem.FSFunction<Void>(){

                    public Void invoke(Repository repository) throws IOException, InterruptedException {
                        GitUtils.validatePushAccess(repository, repositoryUrl, creds);
                        return null;
                    }
                });
            } else {
                List<ErrorMessage.Error> errors = GitUtils.validateCredentials(repositoryUrl, creds);
                if (!errors.isEmpty()) {
                    throw new ServiceException.UnauthorizedException(errors.get(0).getMessage());
                }
            }
        }
        catch (Exception e) {
            return HttpResponses.errorWithoutStack((int)428, (String)e.getMessage());
        }
        return HttpResponses.okJSON();
    }

    @Extension
    public static class GitScmFactory
    extends ScmFactory {
        public Scm getScm(@Nonnull String id, @Nonnull Reachable parent) {
            if (id.equals(GitScm.ID)) {
                return new GitScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new GitScm(parent);
        }
    }
}

