/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.ssh;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ModelObject;
import hudson.model.User;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.ssh.SSHKeyUtils;
import io.jenkins.blueocean.ssh.UserKey;
import java.io.IOException;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserSSHKeyManager {
    private static final int KEY_SIZE = 2048;
    private static final String BLUEOCEAN_GENERATED_SSH_KEY_ID = "jenkins-generated-ssh-key";
    private static final String BLUEOCEAN_DOMAIN_NAME = "blueocean-private-key-domain";

    @NonNull
    public static BasicSSHUserPrivateKey getOrCreate(@NonNull User user) {
        Objects.requireNonNull(user);
        CredentialsStore store = UserSSHKeyManager.getUserStore(user);
        if (store == null) {
            throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", user.getId()));
        }
        for (Credentials cred : store.getCredentials(UserSSHKeyManager.getDomain(store))) {
            BasicSSHUserPrivateKey sshKey;
            if (!(cred instanceof BasicSSHUserPrivateKey) || !BLUEOCEAN_GENERATED_SSH_KEY_ID.equals((sshKey = (BasicSSHUserPrivateKey)cred).getId())) continue;
            return sshKey;
        }
        try {
            String privateKey = SSHKeyUtils.generateKey(2048).trim();
            BasicSSHUserPrivateKey.DirectEntryPrivateKeySource keySource = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey);
            BasicSSHUserPrivateKey key = new BasicSSHUserPrivateKey(CredentialsScope.USER, BLUEOCEAN_GENERATED_SSH_KEY_ID, user.getId(), (BasicSSHUserPrivateKey.PrivateKeySource)keySource, null, BLUEOCEAN_GENERATED_SSH_KEY_ID);
            store.addCredentials(UserSSHKeyManager.getDomain(store), (Credentials)key);
            store.save();
            return key;
        }
        catch (IOException ex) {
            throw new ServiceException.UnexpectedErrorException("Failed to create the private key", (Throwable)ex);
        }
    }

    @NonNull
    public static UserKey getPublicKey(@NonNull User user, @NonNull BasicSSHUserPrivateKey key) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(key);
        String publicKey = SSHKeyUtils.getPublicKey(key.getPrivateKey(), UserSSHKeyManager.getKeyComment(user.getId())).trim();
        return new UserKey(key.getId(), publicKey);
    }

    public static void reset(@NonNull User user) {
        Objects.requireNonNull(user);
        try {
            CredentialsStore store = UserSSHKeyManager.getUserStore(user);
            if (store == null) {
                throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", user.getId()));
            }
            BasicSSHUserPrivateKey key = null;
            for (Credentials cred : store.getCredentials(UserSSHKeyManager.getDomain(store))) {
                BasicSSHUserPrivateKey sshKey;
                if (!(cred instanceof BasicSSHUserPrivateKey) || !BLUEOCEAN_GENERATED_SSH_KEY_ID.equals((sshKey = (BasicSSHUserPrivateKey)cred).getId())) continue;
                key = sshKey;
                break;
            }
            if (key != null) {
                store.removeCredentials(UserSSHKeyManager.getDomain(store), key);
                store.save();
            }
        }
        catch (IOException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to reset the user's key", (Throwable)ex);
        }
    }

    @CheckForNull
    private static CredentialsStore getUserStore(User user) {
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)user)) {
            if (!s.hasPermission(CredentialsProvider.CREATE) || !s.hasPermission(CredentialsProvider.UPDATE)) continue;
            return s;
        }
        return null;
    }

    private static String getKeyComment(String userId) {
        String host = Jenkins.get().getRootUrl();
        if (host == null) {
            host = Jenkins.get().getRootUrlFromRequest();
        }
        host = host.replaceAll(".*//([^/]+).*", "$1");
        return ((userId == null ? Jenkins.get().getDisplayName() : userId) + "@" + host).replaceAll("[^:@._a-zA-Z0-9]", "");
    }

    private static Domain getDomain(CredentialsStore store) {
        Domain domain = store.getDomainByName(BLUEOCEAN_DOMAIN_NAME);
        if (domain == null) {
            try {
                boolean result = store.addDomain(new Domain(BLUEOCEAN_DOMAIN_NAME, null, null), new Credentials[0]);
                if (!result) {
                    throw new ServiceException.UnexpectedErrorException(String.format("Failed to create credential domain: %s", BLUEOCEAN_DOMAIN_NAME));
                }
                domain = store.getDomainByName(BLUEOCEAN_DOMAIN_NAME);
                if (domain == null) {
                    throw new ServiceException.UnexpectedErrorException(String.format("Domain %s created but not found", BLUEOCEAN_DOMAIN_NAME));
                }
            }
            catch (IOException ex) {
                throw new ServiceException.UnexpectedErrorException("Failed to save the Blue Ocean domain.", (Throwable)ex);
            }
        }
        return domain;
    }
}

