/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;

public class SSHKeyUtils {
    public static String generateKey(int keySize) {
        try {
            JSch jsch = new JSch();
            KeyPair pair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)keySize);
            ByteArrayOutputStream keyOut = new ByteArrayOutputStream();
            pair.writePrivateKey((OutputStream)keyOut);
            return new String(keyOut.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    public static String getPublicKey(String privateKey, String comment) {
        try {
            JSch jsch = new JSch();
            KeyPair pair = KeyPair.load((JSch)jsch, (byte[])privateKey.getBytes(StandardCharsets.UTF_8), null);
            ByteArrayOutputStream keyOut = new ByteArrayOutputStream();
            pair.writePublicKey((OutputStream)keyOut, comment);
            return new String(keyOut.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    public static byte[] encodePublicKey(RSAPublicKey key) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] sshrsa = new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97};
            out.write(sshrsa);
            BigInteger e = key.getPublicExponent();
            byte[] data = e.toByteArray();
            SSHKeyUtils.encodeUInt32(data.length, out);
            out.write(data);
            BigInteger m = key.getModulus();
            data = m.toByteArray();
            SSHKeyUtils.encodeUInt32(data.length, out);
            out.write(data);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void encodeUInt32(int value, OutputStream out) throws IOException {
        byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.write(tmp);
    }
}

