/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.User;
import hudson.plugins.git.GitException;
import hudson.remoting.VirtualChannel;
import io.jenkins.blueocean.blueocean_git_pipeline.CloneProgressMonitor;
import io.jenkins.blueocean.blueocean_git_pipeline.GitCloneReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.ssh.UserSSHKeyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

class GitCacheCloneReadSaveRequest
extends GitReadSaveRequest {
    private static final String LOCAL_REF_BASE = "refs/heads/";
    private static final String REMOTE_REF_BASE = "refs/heads/";

    public GitCacheCloneReadSaveRequest(AbstractGitSCMSource gitSource, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents) {
        super(gitSource, branch, commitMessage, sourceBranch, filePath, contents);
    }

    @Override
    byte[] read() throws IOException {
        return this.invokeOnScm(new GitSCMFileSystem.FSFunction<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] invoke(Repository repository) throws IOException, InterruptedException {
                Git activeRepo = GitCacheCloneReadSaveRequest.this.getActiveRepository(repository);
                Repository repo = activeRepo.getRepository();
                File repoDir = repo.getDirectory().getParentFile();
                FileInputStream fis = null;
                try {
                    File f = new File(repoDir, GitCacheCloneReadSaveRequest.this.filePath);
                    if (f.canRead()) {
                        fis = new FileInputStream(f);
                        byte[] byArray = IOUtils.toByteArray((InputStream)fis);
                        return byArray;
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                    FileUtils.deleteDirectory((File)repoDir);
                }
            }
        });
    }

    @Override
    void save() throws IOException {
        this.invokeOnScm(new GitSCMFileSystem.FSFunction<Void>(){

            public Void invoke(Repository repository) throws IOException, InterruptedException {
                Git activeRepo = GitCacheCloneReadSaveRequest.this.getActiveRepository(repository);
                Repository repo = activeRepo.getRepository();
                File repoDir = repo.getDirectory().getParentFile();
                GitReadSaveRequest.log.fine("Repo cloned to: " + repoDir.getCanonicalPath());
                try {
                    File f = new File(repoDir, GitCacheCloneReadSaveRequest.this.filePath);
                    if (!f.exists() || f.canWrite()) {
                        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");){
                            w.write(new String(GitCacheCloneReadSaveRequest.this.contents, "utf-8"));
                        }
                        try {
                            AddCommand add = activeRepo.add();
                            add.addFilepattern(GitCacheCloneReadSaveRequest.this.filePath);
                            add.call();
                            CommitCommand commit = activeRepo.commit();
                            commit.setMessage(GitCacheCloneReadSaveRequest.this.commitMessage);
                            commit.call();
                            GitUtils.push(GitCacheCloneReadSaveRequest.this.gitSource.getRemote(), repo, GitCacheCloneReadSaveRequest.this.getCredential(), "refs/heads/" + GitCacheCloneReadSaveRequest.this.sourceBranch, "refs/heads/" + GitCacheCloneReadSaveRequest.this.branch);
                        }
                        catch (GitAPIException ex) {
                            throw new ServiceException.UnexpectedErrorException(ex.getMessage(), (Throwable)ex);
                        }
                        Void void_ = null;
                        return void_;
                    }
                    throw new ServiceException.UnexpectedErrorException("Unable to write " + GitCacheCloneReadSaveRequest.this.filePath);
                }
                finally {
                    FileUtils.deleteDirectory((File)repoDir);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T invokeOnScm(GitSCMFileSystem.FSFunction<T> function) throws IOException {
        try {
            GitSCMFileSystem fs = this.getFilesystem();
            if (fs != null) return (T)fs.invoke(function);
            GitCloneReadSaveRequest gitClone = new GitCloneReadSaveRequest(this.gitSource, this.branch, this.commitMessage, this.sourceBranch, this.filePath, this.contents);
            GitClient git = gitClone.cloneRepo();
            try {
                Object object = git.withRepository(new RepositoryCallbackToFSFunctionAdapter<T>(function));
                return (T)object;
            }
            finally {
                gitClone.cleanupRepo();
            }
        }
        catch (InterruptedException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to save " + this.filePath, (Throwable)ex);
        }
    }

    private GitSCMFileSystem getFilesystem() throws IOException, InterruptedException {
        try {
            return (GitSCMFileSystem)SCMFileSystem.of((SCMSource)this.gitSource, (SCMHead)new SCMHead(this.sourceBranch));
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (GitException e) {
            if (e.getMessage().contains("Permission denied")) {
                throw new ServiceException.UnauthorizedException("Not authorized", (Throwable)e);
            }
            throw e;
        }
    }

    @Nonnull
    private Git getActiveRepository(Repository repository) throws IOException {
        try {
            CheckoutCommand checkout;
            File cloneDir = File.createTempFile("clone", "");
            if (cloneDir.exists()) {
                if (cloneDir.isDirectory()) {
                    FileUtils.deleteDirectory((File)cloneDir);
                } else if (!cloneDir.delete()) {
                    throw new ServiceException.UnexpectedErrorException("Unable to delete repository clone");
                }
            }
            if (!cloneDir.mkdirs()) {
                throw new ServiceException.UnexpectedErrorException("Unable to create repository clone directory");
            }
            String url = repository.getConfig().getString("remote", "origin", "url");
            Git gitClient = Git.cloneRepository().setCloneAllBranches(false).setProgressMonitor((ProgressMonitor)new CloneProgressMonitor(url)).setURI(repository.getDirectory().getCanonicalPath()).setDirectory(cloneDir).call();
            RemoteRemoveCommand remove = gitClient.remoteRemove();
            remove.setName("origin");
            remove.call();
            RemoteAddCommand add = gitClient.remoteAdd();
            add.setName("origin");
            add.setUri(new URIish(this.gitSource.getRemote()));
            add.call();
            if (GitUtils.isSshUrl(this.gitSource.getRemote())) {
                User user = User.current();
                if (user == null) {
                    throw new ServiceException.UnauthorizedException("Not authenticated");
                }
                BasicSSHUserPrivateKey privateKey = UserSSHKeyManager.getOrCreate(user);
                GitUtils.fetch(repository, (StandardCredentials)privateKey);
            } else {
                FetchCommand fetch = gitClient.fetch();
                fetch.call();
            }
            if (!StringUtils.isEmpty((String)this.sourceBranch) && !this.sourceBranch.equals(this.branch)) {
                checkout = gitClient.checkout();
                checkout.setStartPoint("origin/" + this.sourceBranch);
                checkout.setName(this.sourceBranch);
                checkout.setCreateBranch(true);
                checkout.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK);
                checkout.call();
                checkout = gitClient.checkout();
                checkout.setName(this.branch);
                checkout.setCreateBranch(true);
                checkout.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK);
                checkout.call();
            } else {
                checkout = gitClient.checkout();
                checkout.setStartPoint("origin/" + this.branch);
                checkout.setName(this.branch);
                checkout.setCreateBranch(true);
                checkout.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK);
                checkout.call();
            }
            return gitClient;
        }
        catch (URISyntaxException | GitAPIException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to get working repository directory", ex);
        }
    }

    static class RepositoryCallbackToFSFunctionAdapter<T>
    implements RepositoryCallback<T> {
        private final GitSCMFileSystem.FSFunction<T> function;

        public RepositoryCallbackToFSFunctionAdapter(GitSCMFileSystem.FSFunction<T> function) {
            this.function = function;
        }

        public T invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
            return (T)this.function.invoke(repo);
        }
    }
}

