/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.EnvVars;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.security.ACL;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialsUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitUtils {
    private static final Logger logger = LoggerFactory.getLogger(GitUtils.class);

    GitUtils() {
    }

    static List<ErrorMessage.Error> validateCredentials(@Nonnull String uri, @Nullable StandardCredentials credentials) throws GitException {
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        Git git = new Git(TaskListener.NULL, new EnvVars());
        try {
            GitClient gitClient = git.getClient();
            if (credentials != null) {
                gitClient.addCredentials(uri, credentials);
            }
            gitClient.getRemoteReferences(uri, null, true, false);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error running git remote-ls: " + e.getMessage(), (Throwable)e);
            throw new ServiceException.UnexpectedErrorException("Failed to create pipeline due to unexpected error: " + e.getMessage(), (Throwable)e);
        }
        catch (GitException | IllegalStateException e) {
            logger.error("Error running git remote-ls: " + e.getMessage(), e);
            if (credentials != null) {
                if (e instanceof IllegalStateException || e.getMessage().endsWith("not authorized")) {
                    errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "Invalid credentialId: " + credentials.getId()));
                }
            }
            if (e.getMessage().contains("Authentication is required") || e.getMessage().contains("connection is not authenticated")) {
                errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage()));
            }
            errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage()));
        }
        return errors;
    }

    static StandardCredentials getCredentials(ItemGroup owner, String uri, String credentialId) {
        StandardCredentials standardCredentials = (StandardCredentials)CredentialsUtils.findCredential((String)credentialId, StandardCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (standardCredentials == null) {
            standardCredentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)owner, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialId), GitClient.CREDENTIALS_MATCHER}));
        }
        return standardCredentials;
    }
}

