/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.PersistedList;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineUpdateRequest;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.CheckForNull;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPipelineUpdateRequest
extends BluePipelineUpdateRequest {
    private static final Logger logger = LoggerFactory.getLogger(GitPipelineUpdateRequest.class);
    private final BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GitPipelineUpdateRequest(BlueScmConfig scmConfig) {
        this.scmConfig = scmConfig;
    }

    @CheckForNull
    public BluePipeline update(BluePipeline pipeline) throws IOException {
        Item item = Jenkins.getInstance().getItemByFullName(pipeline.getFullName());
        if (item instanceof MultiBranchProject) {
            Authentication a;
            ACL acl = Jenkins.getInstance().getACL();
            if (!acl.hasPermission(a = Jenkins.getAuthentication(), Item.CONFIGURE)) {
                throw new ServiceException.ForbiddenException(String.format("Failed to update Git pipeline: %s. User %s doesn't have Job configure permission", pipeline.getName(), a.getName()));
            }
            MultiBranchProject mbp = (MultiBranchProject)item;
            BranchSource branchSource = this.getGitScmSource(mbp);
            if (branchSource != null) {
                mbp.getSourcesList().replaceBy(Collections.singleton(branchSource));
                mbp.scheduleBuild2(0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
            }
        }
        return pipeline;
    }

    private BranchSource getGitScmSource(MultiBranchProject mbp) {
        String sourceUri = null;
        String credentialId = null;
        if (this.scmConfig != null) {
            sourceUri = this.scmConfig.getUri();
            ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
            StandardCredentials credentials = null;
            if (this.scmConfig.getCredentialId() != null && (credentials = GitUtils.getCredentials((ItemGroup)Jenkins.getInstance(), sourceUri, this.scmConfig.getCredentialId())) == null) {
                errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.NOT_FOUND.toString(), String.format("credentialId: %s not found", this.scmConfig.getCredentialId())));
            }
            if (sourceUri != null) {
                errors.addAll(GitUtils.validateCredentials(sourceUri, credentials));
            }
            String string = credentialId = this.scmConfig.getCredentialId() == null ? "" : this.scmConfig.getCredentialId();
            if (!errors.isEmpty()) {
                throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline").addAll(errors));
            }
        }
        PersistedList sources = mbp.getSourcesList();
        for (BranchSource source : sources) {
            if (!(source.getSource() instanceof GitSCMSource)) continue;
            GitSCMSource gitSCMSource = (GitSCMSource)source.getSource();
            String remote = gitSCMSource.getRemote();
            if (sourceUri != null && !sourceUri.equals(gitSCMSource.getRemote())) {
                remote = sourceUri;
            }
            String cred = gitSCMSource.getCredentialsId();
            if (!gitSCMSource.getCredentialsId().equals(credentialId)) {
                cred = credentialId;
            }
            GitSCMSource s = new GitSCMSource(gitSCMSource.getId(), remote, cred, gitSCMSource.getIncludes(), gitSCMSource.getExcludes(), gitSCMSource.isIgnoreOnPushNotifications());
            s.setOwner((SCMSourceOwner)mbp);
            return new BranchSource((SCMSource)s);
        }
        if (sourceUri != null) {
            return new BranchSource((SCMSource)new GitSCMSource(null, sourceUri, credentialId, "*", "", false));
        }
        return null;
    }
}

