/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.model.Cause;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanCredentialsProvider;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineCreateRequestImpl;
import java.io.IOException;
import java.util.ArrayList;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPipelineCreateRequest
extends AbstractPipelineCreateRequestImpl {
    private static final String MODE = "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject";
    private static final Logger logger = LoggerFactory.getLogger(GitPipelineCreateRequest.class);
    private BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GitPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.validate(name, scmConfig);
        this.setName(name);
        this.scmConfig = scmConfig;
    }

    public BluePipeline create(Reachable parent) throws IOException {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("Must login to create a pipeline");
        }
        String sourceUri = this.scmConfig.getUri();
        if (sourceUri == null) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline:" + this.getName()).add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "uri is required")));
        }
        TopLevelItem item = this.create((ModifiableTopLevelItemGroup)Jenkins.getInstance(), this.getName(), MODE, MultiBranchProjectDescriptor.class);
        if (item instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject project = (WorkflowMultiBranchProject)item;
            if (StringUtils.isNotBlank((CharSequence)this.scmConfig.getCredentialId())) {
                Domain domain = CredentialsUtils.findDomain((String)this.scmConfig.getCredentialId(), (User)authenticatedUser);
                if (domain == null) {
                    throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline").add(new ErrorMessage.Error("scm.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "No domain in user credentials found for credentialId: " + this.scmConfig.getCredentialId())));
                }
                if (domain.test(new DomainRequirement[]{new BlueOceanDomainRequirement()})) {
                    project.addProperty((AbstractFolderProperty)new BlueOceanCredentialsProvider.FolderPropertyImpl(authenticatedUser.getId(), this.scmConfig.getCredentialId(), BlueOceanCredentialsProvider.createDomain((String)sourceUri)));
                }
            }
            String credentialId = StringUtils.defaultString((String)this.scmConfig.getCredentialId());
            project.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, sourceUri, credentialId, "*", "", false)));
            project.scheduleBuild((Cause)new Cause.UserIdCause());
            return new MultiBranchPipelineImpl((MultiBranchProject)project);
        }
        try {
            item.delete();
        }
        catch (InterruptedException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to delete pipeline: " + this.getName());
        }
        return null;
    }

    private void validate(String name, BlueScmConfig scmConfig) {
        if (scmConfig == null) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline").add(new ErrorMessage.Error("scmConfig", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig is required")));
        }
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        String sourceUri = scmConfig.getUri();
        if (sourceUri == null) {
            errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "uri is required"));
        } else {
            StandardCredentials credentials = null;
            if (scmConfig.getCredentialId() != null && (credentials = GitUtils.getCredentials((ItemGroup)Jenkins.getInstance(), sourceUri, scmConfig.getCredentialId())) == null) {
                errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.NOT_FOUND.toString(), String.format("credentialId: %s not found", scmConfig.getCredentialId())));
            }
            if (scmConfig.getCredentialId() == null || credentials != null) {
                errors.addAll(GitUtils.validateCredentials(sourceUri, credentials));
            }
        }
        try {
            Jenkins.getInstance().getProjectNamingStrategy().checkName(this.getName());
        }
        catch (Failure f) {
            errors.add(new ErrorMessage.Error("scmConfig.name", ErrorMessage.Error.ErrorCodes.INVALID.toString(), name + "in not a valid name"));
        }
        if (Jenkins.getInstance().getItem(name) != null) {
            errors.add(new ErrorMessage.Error("name", ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), name + " already exists"));
        }
        if (!errors.isEmpty()) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline:" + name).addAll(errors));
        }
    }
}

