/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import hudson.model.Cause;
import hudson.model.TopLevelItem;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineCreateRequestImpl;
import java.io.IOException;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitPipelineCreateRequest
extends AbstractPipelineCreateRequestImpl {
    private static final String MODE = "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject";
    private BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GitPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.setName(name);
        if (scmConfig == null) {
            throw new ServiceException.BadRequestExpception("scmConfig is required");
        }
        this.scmConfig = scmConfig;
    }

    public BluePipeline create(Reachable parent) throws IOException {
        String sourceUri = this.scmConfig.getUri();
        if (sourceUri == null) {
            throw new ServiceException.BadRequestExpception("uri is required");
        }
        String credentialId = this.scmConfig.getCredentialId() == null ? "" : this.scmConfig.getCredentialId();
        TopLevelItem item = this.create((ModifiableTopLevelItemGroup)Jenkins.getInstance(), this.getName(), MODE, MultiBranchProjectDescriptor.class);
        if (item instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject project = (WorkflowMultiBranchProject)item;
            project.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, sourceUri, credentialId, "*", "", false)));
            project.scheduleBuild((Cause)new Cause.UserIdCause());
            return new MultiBranchPipelineImpl((MultiBranchProject)project);
        }
        try {
            item.delete();
        }
        catch (InterruptedException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to delete pipeline: " + this.getName());
        }
        return null;
    }
}

