/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.events;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.blueocean.events.PipelineEventChannel;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineInputStepListener;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pubsub.Events;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.pubsub.RunMessage;
import org.jenkinsci.plugins.pubsub.SimpleMessage;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.QueueItemAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;

@Extension
public class PipelineEventListener
implements GraphListener {
    private static final Logger LOGGER = Logger.getLogger(PipelineEventListener.class.getName());
    private final Map<FlowExecution, String> currentStageName = new WeakHashMap<FlowExecution, String>();
    private final Map<FlowExecution, String> currentStageId = new WeakHashMap<FlowExecution, String>();

    public void onNewHead(FlowNode flowNode) {
        if (PipelineNodeUtil.isStage((FlowNode)flowNode)) {
            List<String> branch = this.getBranch(flowNode);
            this.currentStageName.put(flowNode.getExecution(), flowNode.getDisplayName());
            this.currentStageId.put(flowNode.getExecution(), flowNode.getId());
            PipelineEventListener.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_stage, flowNode, branch));
        } else if (flowNode instanceof StepStartNode) {
            if (flowNode.getAction(BodyInvocationAction.class) != null) {
                List<String> branch = this.getBranch(flowNode);
                branch.add(flowNode.getId());
                PipelineEventListener.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_block_start, flowNode, branch));
            } else if (flowNode.getPersistentAction(QueueItemAction.class) != null) {
                List<String> branch = this.getBranch(flowNode);
                PipelineEventListener.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_step, flowNode, branch));
            }
        } else if (flowNode instanceof StepAtomNode) {
            List<String> branch = this.getBranch(flowNode);
            PipelineEventListener.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_step, flowNode, branch));
        } else if (flowNode instanceof StepEndNode) {
            if (flowNode.getAction(BodyInvocationAction.class) != null) {
                BlockStartNode startNode = ((StepEndNode)flowNode).getStartNode();
                String startNodeId = startNode.getId();
                List<String> branch = this.getBranch((FlowNode)startNode);
                branch.add(startNodeId);
                PipelineEventListener.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_block_end, flowNode, branch));
            }
        } else if (flowNode instanceof FlowEndNode) {
            PipelineEventListener.publishEvent(PipelineEventListener.newMessage(PipelineEventChannel.Event.pipeline_end, flowNode.getExecution()));
        }
    }

    List<String> getBranch(FlowNode flowNode) {
        return Lists.reverse((List)flowNode.getAllEnclosingIds());
    }

    private String toPath(Collection<String> branch) {
        StringBuilder builder = new StringBuilder();
        for (String leaf : branch) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(leaf);
        }
        return builder.toString();
    }

    @CheckForNull
    private static Run<?, ?> runFor(FlowExecution exec) {
        Queue.Executable executable;
        try {
            executable = exec.getOwner().getExecutable();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
        if (executable instanceof Run) {
            return (Run)executable;
        }
        return null;
    }

    private static Message newMessage(PipelineEventChannel.Event event, FlowExecution exec) {
        SimpleMessage message = (SimpleMessage)((SimpleMessage)new SimpleMessage().setChannelName("pipeline")).setEventName((Enum)event);
        Run<?, ?> run = PipelineEventListener.runFor(exec);
        if (run != null) {
            ((SimpleMessage)message.set((Enum)PipelineEventChannel.EventProps.pipeline_job_name, run.getParent().getFullName())).set((Enum)PipelineEventChannel.EventProps.pipeline_run_id, run.getId());
        }
        return message;
    }

    private Message newMessage(PipelineEventChannel.Event event, FlowNode flowNode, Collection<String> branch) {
        Run<?, ?> run;
        StepNode stepNode;
        StepDescriptor stepDescriptor;
        Message message = PipelineEventListener.newMessage(event, flowNode.getExecution());
        message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_flownode_id, flowNode.getId());
        message.set((Enum)PipelineEventChannel.EventProps.pipeline_context, this.toPath(branch));
        if (this.currentStageName != null) {
            message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_stage_name, this.currentStageName.get(flowNode.getExecution()));
            message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_stage_id, this.currentStageId.get(flowNode.getExecution()));
        }
        if (flowNode instanceof StepNode && (stepDescriptor = (stepNode = (StepNode)flowNode).getDescriptor()) != null) {
            message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_name, stepDescriptor.getFunctionName());
            if (stepDescriptor instanceof ExecutorStep.DescriptorImpl) {
                Run<?, ?> run2 = PipelineEventListener.runFor(flowNode.getExecution());
                if (run2 != null) {
                    PipelineEventListener.publishJobEvent(run2, Events.JobChannel.job_run_started);
                }
                if (flowNode.getPersistentAction(QueueItemAction.class) != null) {
                    message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_is_paused, String.valueOf(false));
                }
            }
        }
        if (flowNode instanceof StepAtomNode && (run = PipelineEventListener.runFor(flowNode.getExecution())) != null) {
            boolean pausedForInputStep = PipelineNodeUtil.isPausedForInputStep((StepAtomNode)((StepAtomNode)flowNode), (InputAction)((InputAction)run.getAction(InputAction.class)));
            if (pausedForInputStep) {
                PipelineEventListener.publishJobEvent(run, Events.JobChannel.job_run_paused);
            }
            message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_is_paused, String.valueOf(pausedForInputStep));
        }
        return message;
    }

    private static void publishEvent(Message message) {
        try {
            PubsubBus.getBus().publish(message);
        }
        catch (MessageException e) {
            LOGGER.log(Level.SEVERE, "Unexpected error publishing pipeline FlowNode event.", e);
        }
    }

    private static void publishJobEvent(@Nonnull Run<?, ?> run, @Nonnull Events.JobChannel event) {
        try {
            PubsubBus.getBus().publish(new RunMessage(run).setEventName((Enum)event));
        }
        catch (MessageException e) {
            LOGGER.log(Level.WARNING, "Error publishing Job event.", e);
        }
    }

    @Extension
    public static class InputStepPublisher
    implements PipelineInputStepListener {
        public void onStepContinue(InputStep inputStep, WorkflowRun run) {
            try {
                PubsubBus.getBus().publish(new RunMessage((Run)run).setEventName((Enum)Events.JobChannel.job_run_unpaused));
            }
            catch (MessageException e) {
                LOGGER.log(Level.WARNING, "Error publishing Run un-pause event.", e);
            }
        }
    }

    @Extension
    public static class StartPublisher
    extends FlowExecutionListener {
        public void onRunning(FlowExecution execution) {
            PipelineEventListener.publishEvent(PipelineEventListener.newMessage(PipelineEventChannel.Event.pipeline_start, execution));
        }
    }
}

