/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.events;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.Events;
import org.jenkinsci.plugins.pubsub.JobChannelMessage;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageEnricher;
import org.jenkinsci.plugins.pubsub.QueueTaskMessage;

@Extension
public class JobIndexingMessageEnricher
extends MessageEnricher {
    public void enrich(@Nonnull Message message) {
        if (message instanceof JobChannelMessage) {
            JobIndexing.EventProps indexingResult;
            JobIndexing.EventProps indexingStatus;
            JobChannelMessage jobChannelMessage = (JobChannelMessage)message;
            Item jobChannelItem = jobChannelMessage.getJobChannelItem();
            if (jobChannelItem instanceof OrganizationFolder) {
                indexingStatus = JobIndexing.EventProps.job_orgfolder_indexing_status;
                indexingResult = JobIndexing.EventProps.job_orgfolder_indexing_result;
            } else if (jobChannelItem instanceof MultiBranchProject) {
                jobChannelMessage.set((Enum)EventProps.Job.job_ismultibranch, "true");
                indexingStatus = EventProps.Job.job_multibranch_indexing_status;
                indexingResult = EventProps.Job.job_multibranch_indexing_result;
            } else {
                return;
            }
            if (message instanceof QueueTaskMessage) {
                QueueTaskMessage queueTaskMessage = (QueueTaskMessage)message;
                Queue.Item queueItem = queueTaskMessage.getQueueItem();
                if (queueItem instanceof Queue.LeftItem) {
                    Queue.LeftItem leftItem = (Queue.LeftItem)queueItem;
                    if (leftItem.isCancelled()) {
                        jobChannelMessage.set((Enum)indexingStatus, "COMPLETE");
                        jobChannelMessage.set((Enum)indexingResult, "CANCELLED");
                    } else if (message.getEventName().equals(Events.JobChannel.job_run_queue_task_complete.name())) {
                        OrganizationFolder.OrganizationScan orgScan;
                        Result result;
                        jobChannelMessage.set((Enum)indexingStatus, "COMPLETE");
                        Queue.Executable executable = ((Queue.LeftItem)queueItem).getExecutable();
                        if (executable instanceof MultiBranchProject.BranchIndexing) {
                            MultiBranchProject.BranchIndexing branchIndexing = (MultiBranchProject.BranchIndexing)executable;
                            Result result2 = branchIndexing.getResult();
                            if (result2 != null) {
                                jobChannelMessage.set((Enum)indexingResult, result2.toString());
                            }
                        } else if (executable instanceof OrganizationFolder.OrganizationScan && (result = (orgScan = (OrganizationFolder.OrganizationScan)executable).getResult()) != null) {
                            jobChannelMessage.set((Enum)indexingResult, result.toString());
                        }
                    } else {
                        jobChannelMessage.set((Enum)indexingStatus, "INDEXING");
                    }
                } else {
                    jobChannelMessage.set((Enum)indexingStatus, "INDEXING");
                }
            }
        }
    }

    public static interface JobIndexing {

        public static enum EventProps {
            job_orgfolder_indexing_status,
            job_orgfolder_indexing_result;

        }
    }
}

