/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.events;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.JobChannelMessage;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageEnricher;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class BlueMessageEnricher
extends MessageEnricher {
    private static final Logger LOGGER = Logger.getLogger(BlueMessageEnricher.class.getName());

    public void enrich(@Nonnull Message message) {
        String channelName = message.getChannelName();
        if (channelName.equals("job") && message instanceof JobChannelMessage) {
            ItemGroup parent;
            JobChannelMessage jobChannelMessage = (JobChannelMessage)message;
            Item jobChannelItem = jobChannelMessage.getJobChannelItem();
            if (jobChannelItem == null) {
                return;
            }
            Link jobUrl = LinkResolver.resolveLink((Object)jobChannelItem);
            BlueOrganization org = OrganizationFactory.getInstance().getContainingOrg(jobChannelItem);
            if (org != null) {
                message.set((Enum)EventProps.Jenkins.jenkins_org, org.getName());
            }
            jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_rest_url, jobUrl.getHref());
            jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_pipeline_name, jobChannelItem.getFullName());
            if (jobChannelItem instanceof WorkflowJob && (parent = jobChannelItem.getParent()) instanceof WorkflowMultiBranchProject) {
                String multiBranchProjectName = parent.getFullName();
                jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_pipeline_name, multiBranchProjectName);
                jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_branch_name, jobChannelItem.getName());
            }
            if (message.containsKey((Object)"job_run_queueId") && jobChannelItem instanceof Job) {
                Job job;
                long queueId = Long.parseLong(message.get("job_run_queueId"));
                Queue.Item queueItem = Jenkins.getInstance().getQueue().getItem(queueId);
                BlueQueueItem blueQueueItem = QueueUtil.getQueuedItem((Queue.Item)queueItem, (Job)(job = (Job)jobChannelItem));
                if (blueQueueItem != null) {
                    jobChannelMessage.set((Enum)BlueEventProps.blueocean_queue_item_expected_build_number, Integer.toString(blueQueueItem.getExpectedBuildNumber()));
                } else {
                    Run run = QueueUtil.getRun((Job)job, (long)queueId);
                    if (run == null) {
                        return;
                    }
                    jobChannelMessage.set((Enum)BlueEventProps.blueocean_queue_item_expected_build_number, Integer.toString(run.getNumber()));
                }
            }
        }
    }

    static enum BlueEventProps {
        blueocean_job_rest_url,
        blueocean_job_pipeline_name,
        blueocean_job_branch_name,
        blueocean_queue_item_expected_build_number;

    }
}

