/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.events;

import hudson.Extension;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import javax.annotation.Nonnull;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkins.pubsub.EventProps;
import org.jenkins.pubsub.JobChannelMessage;
import org.jenkins.pubsub.Message;
import org.jenkins.pubsub.MessageEnricher;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class BlueMessageEnricher
extends MessageEnricher {
    public void enrich(@Nonnull Message message) {
        message.set((Enum)EventProps.Jenkins.jenkins_org, OrganizationImpl.INSTANCE.getName());
        String channelName = message.getChannelName();
        if (channelName.equals("job")) {
            ItemGroup parent;
            JobChannelMessage jobChannelMessage = (JobChannelMessage)message;
            ParameterizedJobMixIn.ParameterizedJob job = jobChannelMessage.getJob();
            Link jobUrl = LinkResolver.resolveLink((Object)job);
            jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_rest_url, jobUrl.getHref());
            jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_pipeline_name, job.getFullName());
            if (job instanceof WorkflowJob && (parent = job.getParent()) instanceof WorkflowMultiBranchProject) {
                String multiBranchProjectName = parent.getFullName();
                jobChannelMessage.set((Enum)EventProps.Job.job_ismultibranch, "true");
                jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_pipeline_name, multiBranchProjectName);
                jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_branch_name, job.getName());
            }
        }
    }

    static enum BlueEventProps {
        blueocean_job_rest_url,
        blueocean_job_pipeline_name,
        blueocean_job_branch_name;

    }
}

