/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.events;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.blueocean.events.PipelineEventChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.pubsub.Message;
import org.jenkins.pubsub.MessageException;
import org.jenkins.pubsub.PubsubBus;
import org.jenkins.pubsub.SimpleMessage;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class PipelineEventListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(PipelineEventListener.class.getName());
    private ExecutorService executor = new ThreadPoolExecutor(0, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public void onStarted(final Run<?, ?> run, TaskListener listener) {
        super.onStarted(run, listener);
        if (run instanceof WorkflowRun) {
            ListenableFuture promise = ((WorkflowRun)run).getExecutionPromise();
            promise.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        FlowExecution ex = (FlowExecution)((WorkflowRun)run).getExecutionPromise().get();
                        ex.addListener((GraphListener)new StageEventPublisher(run));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Unexpected error publishing pipeline FlowNode event.", e);
                    }
                }
            }, (Executor)this.executor);
        }
    }

    private class StageEventPublisher
    implements GraphListener {
        private final Run run;
        private final PubsubBus pubSubBus;
        private String currentStageName;
        private String currentStageId;

        public StageEventPublisher(Run r) {
            this.run = r;
            this.pubSubBus = PubsubBus.getBus();
            this.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_start));
        }

        public void onNewHead(FlowNode flowNode) {
            if (flowNode instanceof StepStartNode) {
                if (flowNode.getAction(BodyInvocationAction.class) != null) {
                    List<String> branch = this.getBranch(flowNode);
                    branch.add(flowNode.getId());
                    this.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_block_start, flowNode, branch));
                }
            } else if (flowNode instanceof StepAtomNode) {
                List<String> branch = this.getBranch(flowNode);
                StageAction stageAction = (StageAction)flowNode.getAction(StageAction.class);
                if (stageAction != null) {
                    this.currentStageName = stageAction.getStageName();
                    this.currentStageId = flowNode.getId();
                }
                this.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_step, flowNode, branch));
            } else if (flowNode instanceof StepEndNode) {
                if (flowNode.getAction(BodyInvocationAction.class) != null) {
                    try {
                        String startNodeId = ((StepStartNode)((StepEndNode)flowNode).getStartNode()).getId();
                        FlowNode startNode = flowNode.getExecution().getNode(startNodeId);
                        List<String> branch = this.getBranch(startNode);
                        branch.add(startNodeId);
                        this.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_block_end, flowNode, branch));
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Unexpected error publishing pipeline FlowNode event.", e);
                    }
                }
            } else if (flowNode instanceof FlowEndNode) {
                this.publishEvent(this.newMessage(PipelineEventChannel.Event.pipeline_end));
            }
        }

        private List<String> getBranch(FlowNode flowNode) {
            ArrayList<String> branch = new ArrayList<String>();
            FlowNode parentBlock = this.getParentBlock(flowNode);
            while (parentBlock != null) {
                branch.add(0, parentBlock.getId());
                parentBlock = this.getParentBlock(parentBlock);
            }
            return branch;
        }

        private FlowNode getParentBlock(FlowNode flowNode) {
            List parents = flowNode.getParents();
            for (FlowNode parent : parents) {
                if (!(parent instanceof StepStartNode) || parent.getAction(BodyInvocationAction.class) == null) continue;
                return parent;
            }
            for (FlowNode parent : parents) {
                FlowNode grandparent;
                if (parent instanceof StepEndNode || (grandparent = this.getParentBlock(parent)) == null) continue;
                return grandparent;
            }
            return null;
        }

        private String toPath(List<String> branch) {
            StringBuilder builder = new StringBuilder();
            for (String leaf : branch) {
                if (builder.length() > 0) {
                    builder.append("/");
                }
                builder.append(leaf);
            }
            return builder.toString();
        }

        private Message newMessage(PipelineEventChannel.Event event) {
            return ((SimpleMessage)((SimpleMessage)((SimpleMessage)new SimpleMessage().setChannelName("pipeline")).setEventName((Enum)event)).set((Enum)PipelineEventChannel.EventProps.pipeline_job_name, this.run.getParent().getFullName())).set((Enum)PipelineEventChannel.EventProps.pipeline_run_id, this.run.getId());
        }

        private Message newMessage(PipelineEventChannel.Event event, FlowNode flowNode, List<String> branch) {
            Message message = this.newMessage(event);
            message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_flownode_id, flowNode.getId());
            message.set((Enum)PipelineEventChannel.EventProps.pipeline_context, this.toPath(branch));
            if (this.currentStageName != null) {
                message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_stage_name, this.currentStageName);
                message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_stage_id, this.currentStageId);
            }
            if (flowNode instanceof StepNode) {
                StepNode stepNode = (StepNode)flowNode;
                message.set((Enum)PipelineEventChannel.EventProps.pipeline_step_name, stepNode.getDescriptor().getFunctionName());
            }
            return message;
        }

        private void publishEvent(Message message) {
            try {
                this.pubSubBus.publish(message);
            }
            catch (MessageException e) {
                LOGGER.log(Level.SEVERE, "Unexpected error publishing pipeline FlowNode event.", e);
            }
        }
    }
}

