/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons;

import io.jenkins.blueocean.commons.BlueUrlTokenizer;
import io.jenkins.blueocean.commons.PageStatePreloader;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;

public abstract class RESTFetchPreloader
extends PageStatePreloader {
    @Override
    public final String getStatePropertyPath() {
        return "prefetchdata." + this.getClass().getSimpleName();
    }

    @Override
    public final String getStateJson() {
        BlueUrlTokenizer blueUrl = BlueUrlTokenizer.parseCurrentRequest();
        if (blueUrl == null) {
            return null;
        }
        FetchData fetchData = this.getFetchData(blueUrl);
        if (fetchData != null) {
            return fetchData.toJSON();
        }
        return null;
    }

    protected abstract FetchData getFetchData(@Nonnull BlueUrlTokenizer var1);

    public static final class FetchData {
        private String restUrl;
        private String data;

        public FetchData(@Nonnull String restUrl, @Nonnull String data) {
            this.restUrl = restUrl;
            this.data = data;
        }

        public String getRestUrl() {
            return this.restUrl;
        }

        public String getData() {
            return this.data;
        }

        public String toJSON() {
            JSONObject json = new JSONObject();
            json.put("restUrl", (Object)this.restUrl);
            json.put("data", (Object)this.data);
            return json.toString();
        }
    }
}

