/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.blueocean.commons.stapler.export.ClassAttributeBehaviour;
import io.jenkins.blueocean.commons.stapler.export.ExportInterceptor;
import io.jenkins.blueocean.commons.stapler.export.Flavor;

public class ExportConfig {
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public boolean prettyPrint;
    private ClassAttributeBehaviour classAttribute = ClassAttributeBehaviour.IF_NEEDED;
    private ExportInterceptor exportInterceptor = ExportInterceptor.DEFAULT;
    private boolean skipIfFail = false;
    private Flavor flavor = Flavor.JSON;
    private boolean htmlEncode = false;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public ExportConfig withPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public ClassAttributeBehaviour getClassAttribute() {
        return this.classAttribute;
    }

    public ExportConfig withClassAttribute(ClassAttributeBehaviour cab) {
        if (cab == null) {
            throw new NullPointerException();
        }
        this.classAttribute = cab;
        return this;
    }

    public ExportInterceptor getExportInterceptor() {
        return this.exportInterceptor;
    }

    public ExportConfig withExportInterceptor(ExportInterceptor interceptor) {
        this.exportInterceptor = interceptor;
        return this;
    }

    public ExportConfig withSkipIfFail(boolean skipIfFail) {
        this.skipIfFail = skipIfFail;
        return this;
    }

    public boolean isSkipIfFail() {
        return this.skipIfFail;
    }

    public Flavor getFlavor() {
        return this.flavor;
    }

    public ExportConfig withFlavor(Flavor flavor) {
        this.flavor = flavor;
        return this;
    }

    public boolean isHtmlEncode() {
        return this.htmlEncode;
    }

    public ExportConfig withHtmlEncode(boolean htmlEncode) {
        this.htmlEncode = htmlEncode;
        return this;
    }
}

