/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.ExportConfig;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringEscapeUtils;

class JSONDataWriter
implements DataWriter {
    private static final JsonStringEncoder jsonEncoder = new JsonStringEncoder();
    protected boolean needComma;
    protected final Writer out;
    protected final ExportConfig config;
    private int indent;
    private String classAttr;
    private static final char[] INDENT = new char[32];

    JSONDataWriter(Writer out, ExportConfig config) throws IOException {
        this.out = out;
        this.config = config;
        this.indent = config.isPrettyPrint() ? 0 : -1;
    }

    @Override
    @Nonnull
    public ExportConfig getExportConfig() {
        return this.config;
    }

    @Override
    public void name(String name) throws IOException {
        this.comma();
        if (this.indent < 0) {
            this.out.write('\"' + name + "\":");
        } else {
            this.out.write('\"' + name + "\" : ");
        }
        this.needComma = false;
    }

    protected void data(String v) throws IOException {
        this.comma();
        this.out.write(v);
    }

    protected void comma() throws IOException {
        if (this.needComma) {
            this.out.write(44);
            this.indent();
        }
        this.needComma = true;
    }

    private void indent() throws IOException {
        if (this.indent >= 0) {
            int len;
            this.out.write(10);
            for (int i = this.indent * 2; i > 0; i -= len) {
                len = Math.min(i, INDENT.length);
                this.out.write(INDENT, 0, len);
            }
        }
    }

    private void inc() {
        if (this.indent < 0) {
            return;
        }
        ++this.indent;
    }

    private void dec() {
        if (this.indent < 0) {
            return;
        }
        --this.indent;
    }

    @Override
    public void valuePrimitive(Object v) throws IOException {
        this.data(v.toString());
    }

    @Override
    public void value(String v) throws IOException {
        StringBuilder buf = new StringBuilder(v.length());
        buf.append('\"');
        if (this.config.isHtmlEncode()) {
            jsonEncoder.quoteAsString((CharSequence)StringEscapeUtils.escapeHtml((String)v), buf);
        } else {
            jsonEncoder.quoteAsString((CharSequence)v, buf);
        }
        buf.append('\"');
        this.data(buf.toString());
    }

    @Override
    public void valueNull() throws IOException {
        this.data("null");
    }

    private void open(char symbol) throws IOException {
        this.comma();
        this.out.write(symbol);
        this.needComma = false;
        this.inc();
        this.indent();
    }

    private void close(char symbol) throws IOException {
        this.dec();
        this.indent();
        this.needComma = true;
        this.out.write(symbol);
    }

    @Override
    public void startArray() throws IOException {
        this.open('[');
    }

    @Override
    public void endArray() throws IOException {
        this.close(']');
    }

    @Override
    public void type(Type expected, Class actual) throws IOException {
        this.classAttr = this.config.getClassAttribute().print(expected, actual);
    }

    @Override
    public void startObject() throws IOException {
        this._startObject();
        if (this.classAttr != null) {
            this.name("_class");
            this.value(this.classAttr);
            this.classAttr = null;
        }
    }

    protected void _startObject() throws IOException {
        this.open('{');
    }

    @Override
    public void endObject() throws IOException {
        this.close('}');
    }

    static {
        for (int i = 0; i < INDENT.length; ++i) {
            JSONDataWriter.INDENT[i] = 32;
        }
    }
}

