/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler;

import io.jenkins.blueocean.commons.stapler.Export;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;
import org.kohsuke.stapler.verb.HttpVerbInterceptor;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@InterceptorAnnotation(value=Processor.class)
public @interface TreeResponse {

    public static class Processor
    extends Interceptor {
        public Object invoke(StaplerRequest request, StaplerResponse response, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            if (this.matches(request)) {
                final Object resp = this.target.invoke(request, response, instance, arguments);
                return new HttpResponse(){

                    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                        Export.doJson(req, rsp, resp);
                    }
                };
            }
            throw new CancelRequestHandlingException();
        }

        private boolean matches(StaplerRequest request) {
            String method = request.getMethod();
            for (Annotation a : this.target.getAnnotations()) {
                Class<? extends Annotation> t = a.annotationType();
                InterceptorAnnotation ia = t.getAnnotation(InterceptorAnnotation.class);
                if (ia == null || ia.value() != HttpVerbInterceptor.class) continue;
                return t.getName().endsWith(method);
            }
            return method.equals("GET");
        }
    }
}

