/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import com.google.common.base.Predicate;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.FieldProperty;
import io.jenkins.blueocean.commons.stapler.export.FilteringTreePruner;
import io.jenkins.blueocean.commons.stapler.export.MethodProperty;
import io.jenkins.blueocean.commons.stapler.export.ModelBuilder;
import io.jenkins.blueocean.commons.stapler.export.NotExportableException;
import io.jenkins.blueocean.commons.stapler.export.Property;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class Model<T> {
    public final Class<T> type;
    public final Model<? super T> superModel;
    private final Property[] properties;
    final ModelBuilder parent;
    final int defaultVisibility;
    private volatile Properties javadoc;
    private final Set<String> propertyNames = new HashSet<String>();
    final Predicate<String> HAS_PROPERTY_NAME = new Predicate<String>(){

        public boolean apply(@Nullable String name) {
            return Model.this.propertyNames.contains(name);
        }
    };
    final Predicate<String> HAS_PROPERTY_NAME_IN_ANCESTORY = new Predicate<String>(){

        public boolean apply(@Nullable String name) {
            Model m = Model.this;
            while (m != null) {
                if (m.propertyNames.contains(name)) {
                    return true;
                }
                m = m.superModel;
            }
            return false;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(Model.class.getName());

    Model(ModelBuilder parent, Class<T> type, @CheckForNull Class<?> propertyOwner, @Nullable String property) throws NotExportableException {
        Exported exported;
        this.parent = parent;
        this.type = type;
        ExportedBean eb = type.getAnnotation(ExportedBean.class);
        if (eb == null) {
            throw propertyOwner != null ? new NotExportableException(type, propertyOwner, property) : new NotExportableException(type);
        }
        this.defaultVisibility = eb.defaultVisibility();
        Class<T> sc = type.getSuperclass();
        this.superModel = sc != null && sc.getAnnotation(ExportedBean.class) != null ? parent.get(sc) : null;
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Field field : type.getFields()) {
            if (field.getDeclaringClass() != type || (exported = field.getAnnotation(Exported.class)) == null) continue;
            properties.add(new FieldProperty(this, field, exported));
        }
        for (AccessibleObject accessibleObject : type.getMethods()) {
            if (((Method)accessibleObject).getDeclaringClass() != type || ((Method)accessibleObject).isSynthetic() && ((Method)accessibleObject).isBridge() || (exported = ((Method)accessibleObject).getAnnotation(Exported.class)) == null) continue;
            if (((Method)accessibleObject).getParameterTypes().length > 0) {
                LOGGER.log(Level.WARNING, "Method " + ((Method)accessibleObject).getName() + " of " + type.getName() + " is annotated @Exported but requires arguments");
                continue;
            }
            properties.add(new MethodProperty(this, (Method)accessibleObject, exported));
        }
        this.properties = properties.toArray(new Property[properties.size()]);
        Arrays.sort(this.properties);
        for (Property p : properties) {
            this.propertyNames.add(p.name);
        }
        parent.models.put(type, this);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(Arrays.asList(this.properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getJavadoc() {
        if (this.javadoc != null) {
            return this.javadoc;
        }
        Model model = this;
        synchronized (model) {
            if (this.javadoc != null) {
                return this.javadoc;
            }
            Properties p = new Properties();
            InputStream is = this.type.getClassLoader().getResourceAsStream(this.type.getName().replace('$', '/').replace('.', '/') + ".javadoc");
            if (is != null) {
                try {
                    try {
                        p.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load javadoc for " + this.type, e);
                }
            }
            this.javadoc = p;
            return this.javadoc;
        }
    }

    public void writeTo(T object, DataWriter writer) throws IOException {
        this.writeTo(object, 0, writer);
    }

    public void writeTo(T object, TreePruner pruner, DataWriter writer) throws IOException {
        try {
            writer.type(null, object.getClass());
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        writer.startObject();
        this.writeNestedObjectTo(object, pruner, writer);
        writer.endObject();
    }

    @Deprecated
    public void writeTo(T object, int baseVisibility, DataWriter writer) throws IOException {
        this.writeTo(object, new TreePruner.ByDepth(1 - baseVisibility), writer);
    }

    void writeNestedObjectTo(T object, TreePruner pruner, DataWriter writer) throws IOException {
        if (this.superModel != null) {
            this.superModel.writeNestedObjectTo(object, new FilteringTreePruner(this.HAS_PROPERTY_NAME, pruner), writer);
        }
        for (Property p : this.properties) {
            p.writeTo(object, pruner, writer);
        }
    }
}

