/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler;

import io.jenkins.blueocean.commons.JsonConverter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.servlet.ServletException;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.StaplerRequest;

@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@InjectedParameter(value=Handler.class)
public @interface JsonBody {

    public static class Handler
    extends AnnotationHandler {
        public Object parse(StaplerRequest request, Annotation a, Class type, String parameterName) throws ServletException {
            String ct = request.getContentType();
            if (ct == null || !ct.startsWith("application/json")) {
                throw new ServletException("Expected application/json but got " + ct);
            }
            try {
                return JsonConverter.toJava(request.getReader(), type);
            }
            catch (IOException e) {
                throw new ServletException("Failed to read JSON", (Throwable)e);
            }
        }
    }
}

