/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler;

import hudson.ExtensionList;
import hudson.PluginWrapper;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.ExportConfig;
import io.jenkins.blueocean.commons.stapler.export.ExportInterceptor;
import io.jenkins.blueocean.commons.stapler.export.Flavor;
import io.jenkins.blueocean.commons.stapler.export.Model;
import io.jenkins.blueocean.commons.stapler.export.ModelBuilder;
import io.jenkins.blueocean.commons.stapler.export.NamedPathPruner;
import io.jenkins.blueocean.commons.stapler.export.Property;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.SecureRequester;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export {
    private static final Logger logger = LoggerFactory.getLogger(Export.class);
    private static ModelBuilder MODEL_BUILDER = new ModelBuilder();

    @Nonnull
    public static String toJson(@Nonnull Object object) throws IOException {
        try (StringWriter writer = new StringWriter();){
            Export.toJson(object, writer);
            String string = writer.toString();
            return string;
        }
    }

    public static void toJson(@Nonnull Object object, @Nonnull Writer writer) throws IOException {
        Model<?> model = new ModelBuilder().get(object.getClass());
        model.writeTo(object, Flavor.JSON.createDataWriter(object, writer, Export.createExportConfig()));
        writer.flush();
    }

    public static void doJson(StaplerRequest req, StaplerResponse rsp, Object bean) throws IOException, ServletException {
        if (req.getParameter("jsonp") == null || Export.permit(req, bean)) {
            rsp.setHeader("X-Jenkins", Jenkins.VERSION);
            rsp.setHeader("X-Jenkins-Session", Jenkins.SESSION_HASH);
            ExportConfig exportConfig = Export.createExportConfig().withFlavor(req.getParameter("jsonp") == null ? Flavor.JSON : Flavor.JSONP).withPrettyPrint(req.hasParameter("pretty")).withSkipIfFail(true);
            Export.serveExposedBean(req, rsp, bean, exportConfig);
        } else {
            rsp.sendError(403, "jsonp forbidden; implement jenkins.security.SecureRequester");
        }
    }

    private static ExportConfig createExportConfig() {
        return new ExportConfig().withExportInterceptor(new BlueOceanExportInterceptor());
    }

    private static boolean permit(StaplerRequest req, Object bean) {
        for (SecureRequester r : ExtensionList.lookup(SecureRequester.class)) {
            if (!r.permit(req, bean)) continue;
            return true;
        }
        return false;
    }

    private static void serveExposedBean(StaplerRequest req, StaplerResponse resp, Object exposedBean, ExportConfig config) throws ServletException, IOException {
        TreePruner pruner;
        String tree;
        Flavor flavor = config.getFlavor();
        String pad = null;
        resp.setContentType(flavor.contentType);
        Writer w = resp.getCompressedWriter((HttpServletRequest)req);
        if ((flavor == Flavor.JSON || flavor == Flavor.JSONP) && (pad = req.getParameter("jsonp")) != null) {
            w.write(pad + '(');
        }
        if ((tree = req.getParameter("tree")) != null) {
            try {
                pruner = new NamedPathPruner(tree);
            }
            catch (IllegalArgumentException x) {
                throw new ServletException("Malformed tree expression: " + x, (Throwable)x);
            }
        }
        int depth = 0;
        try {
            String s = req.getParameter("depth");
            if (s != null) {
                depth = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            throw new ServletException("Depth parameter must be a number");
        }
        pruner = new TreePruner.ByDepth(1 - depth);
        DataWriter dw = flavor.createDataWriter(exposedBean, w, config);
        if (exposedBean instanceof Object[]) {
            dw.startArray();
            for (Object item : (Object[])exposedBean) {
                Export.writeOne(pruner, dw, item);
            }
            dw.endArray();
        } else {
            Export.writeOne(pruner, dw, exposedBean);
        }
        if (pad != null) {
            w.write(41);
        }
        w.close();
    }

    private static void writeOne(TreePruner pruner, DataWriter dw, Object item) throws IOException {
        Model<?> p = MODEL_BUILDER.get(item.getClass());
        p.writeTo(item, pruner, dw);
    }

    private Export() {
    }

    public static class BlueOceanExportInterceptor
    extends ExportInterceptor {
        @Override
        public Object getValue(Property property, Object model, ExportConfig config) throws IOException {
            if (model instanceof Action) {
                try {
                    return property.getValue(model);
                }
                catch (Throwable e) {
                    this.printError(model.getClass(), e);
                    return SKIP;
                }
            }
            if (model instanceof Item || model instanceof Run) {
                return SKIP;
            }
            return ExportInterceptor.DEFAULT.getValue(property, model, config);
        }

        private void printError(Class modelClass, Throwable e) {
            String msg;
            PluginWrapper plugin = Jenkins.getInstance().getPluginManager().whichPlugin(modelClass);
            if (plugin != null) {
                String url = plugin.getUrl() == null ? "https://issues.jenkins-ci.org/" : plugin.getUrl();
                msg = "BUG: Problem with serializing <" + modelClass + "> belonging to plugin <" + plugin.getLongName() + ">. Report the stacktrace below to the plugin author by visiting " + url;
            } else {
                msg = "BUG: Problem with serializing <" + modelClass + ">";
            }
            if (e != null) {
                logger.error(msg, e);
            } else {
                logger.error(msg);
            }
        }
    }
}

