/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Range {
    public final int min;
    public final int max;
    public static final Range ALL = new Range(0, Integer.MAX_VALUE);

    public Range(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public <T> List<T> apply(T[] a) {
        return this.apply(Arrays.asList(a));
    }

    public <T> List<T> apply(List<T> s) {
        if (this.max < s.size()) {
            s = s.subList(0, this.max);
        }
        if (this.min > 0) {
            s = s.subList(this.min, s.size());
        }
        return s;
    }

    public <T> Iterable<T> apply(Collection<T> s) {
        return this.apply((Iterable<T>)s);
    }

    public <T> Iterable<T> apply(final Iterable<T> s) {
        if (s instanceof List) {
            return this.apply((List)s);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator itr = s.iterator();
                itr = Iterators.limit(itr, (int)Range.this.max);
                if (Range.this.min > 0) {
                    Range.advance(itr, Range.this.min);
                }
                return itr;
            }
        };
    }

    public static int advance(Iterator<?> iterator, int numberToAdvance) {
        int i = 0;
        while (i < numberToAdvance && iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }
}

