/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import io.jenkins.blueocean.commons.stapler.export.Property;
import io.jenkins.blueocean.commons.stapler.export.Range;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class NamedPathPruner
extends TreePruner {
    private final Tree tree;

    static Tree parse(String spec) throws IllegalArgumentException {
        Reader r = new Reader(spec);
        Tree t = new Tree();
        NamedPathPruner.list(r, t);
        r.expect(Token.EOF);
        return t;
    }

    private static void list(Reader r, Tree t) throws IllegalArgumentException {
        NamedPathPruner.node(r, t);
        if (r.accept(Token.COMMA)) {
            NamedPathPruner.list(r, t);
        }
    }

    private static void node(Reader r, Tree t) throws IllegalArgumentException {
        Object actual = r.peek();
        if (actual instanceof Token) {
            throw new IllegalArgumentException("expected name at " + r.pos);
        }
        r.advance();
        Tree subtree = new Tree();
        t.children.put((String)actual, subtree);
        if (r.accept(Token.LBRACE)) {
            NamedPathPruner.list(r, subtree);
            r.expect(Token.RBRACE);
        }
        if (r.accept(Token.QLBRACE)) {
            subtree.range = NamedPathPruner.parseRange(r);
            r.expect(Token.QRBRACE);
        }
    }

    static Range parseRange(Reader r) {
        if (r.accept(Token.COMMA)) {
            return new Range(0, r.expectNumber());
        }
        int min = r.expectNumber();
        if (r.peek() == Token.QRBRACE) {
            return new Range(min, min + 1);
        }
        r.expect(Token.COMMA);
        if (r.peek() == Token.QRBRACE) {
            return new Range(min, Integer.MAX_VALUE);
        }
        return new Range(min, r.expectNumber());
    }

    public NamedPathPruner(String spec) throws IllegalArgumentException {
        this(NamedPathPruner.parse(spec));
    }

    private NamedPathPruner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public TreePruner accept(Object node, Property prop) {
        if (prop.merge) {
            return this;
        }
        Tree subtree = this.tree.children.get(prop.name);
        if (subtree == null) {
            subtree = this.tree.children.get("*");
        }
        return subtree != null ? new NamedPathPruner(subtree) : null;
    }

    @Override
    public Range getRange() {
        return this.tree.range;
    }

    private static class Reader {
        private final String text;
        int pos;
        int next;

        Reader(String text) {
            this.text = text;
            this.pos = 0;
        }

        Object peek() {
            if (this.pos == this.text.length()) {
                return Token.EOF;
            }
            switch (this.text.charAt(this.pos)) {
                case ',': {
                    this.next = this.pos + 1;
                    return Token.COMMA;
                }
                case '[': {
                    this.next = this.pos + 1;
                    return Token.LBRACE;
                }
                case ']': {
                    this.next = this.pos + 1;
                    return Token.RBRACE;
                }
                case '{': {
                    this.next = this.pos + 1;
                    return Token.QLBRACE;
                }
                case '}': {
                    this.next = this.pos + 1;
                    return Token.QRBRACE;
                }
            }
            this.next = this.text.length();
            for (char c : new char[]{',', '[', ']', '{', '}'}) {
                int x = this.text.indexOf(c, this.pos);
                if (x == -1 || x >= this.next) continue;
                this.next = x;
            }
            return this.text.substring(this.pos, this.next);
        }

        void advance() {
            this.pos = this.next;
        }

        void expect(Token tok) throws IllegalArgumentException {
            Object actual = this.peek();
            if (actual != tok) {
                throw new IllegalArgumentException("expected " + (Object)((Object)tok) + " at " + this.pos);
            }
            this.advance();
        }

        int expectNumber() {
            Object t = this.peek();
            if (!(t instanceof String) || !Pattern.matches("[0-9]+$", (String)t)) {
                throw new IllegalArgumentException("expected number at " + this.pos);
            }
            this.advance();
            return Integer.parseInt((String)t);
        }

        boolean accept(Token tok) {
            if (this.peek() == tok) {
                this.advance();
                return true;
            }
            return false;
        }
    }

    private static enum Token {
        COMMA,
        LBRACE,
        RBRACE,
        QLBRACE,
        QRBRACE,
        EOF;

    }

    static class Tree {
        final Map<String, Tree> children = new TreeMap<String, Tree>();
        Range range = Range.ALL;

        Tree() {
        }

        public String toString() {
            return this.children.toString();
        }
    }
}

