/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public class BlueUrlTokenizer {
    private static final Set<String> PIPELINE_TABS = new LinkedHashSet<String>(Arrays.asList("activity", "branches", "pr"));
    private static final Set<String> PIPELINE_RUN_DETAIL_TABS = new LinkedHashSet<String>(Arrays.asList("pipeline", "changes", "tests", "artifacts"));
    private Map<UrlPart, String> urlParts = new LinkedHashMap<UrlPart, String>();
    private UrlPart lastPart;

    private BlueUrlTokenizer() {
    }

    @CheckForNull
    public static BlueUrlTokenizer parseCurrentRequest() throws IllegalStateException {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest == null) {
            throw new IllegalStateException("Illegal call to BlueoceanUrl.parseCurrentRequest outside the scope of an active StaplerRequest.");
        }
        String path = currentRequest.getOriginalRequestURI();
        String contextPath = currentRequest.getContextPath();
        path = path.substring(contextPath.length());
        return BlueUrlTokenizer.parse(path);
    }

    @CheckForNull
    public static BlueUrlTokenizer parse(@Nonnull String url) {
        Iterator<String> urlTokens = BlueUrlTokenizer.extractTokens(url);
        if (urlTokens.hasNext() && urlTokens.next().equalsIgnoreCase("blue")) {
            BlueUrlTokenizer blueUrlTokenizer = new BlueUrlTokenizer();
            if (urlTokens.hasNext()) {
                String next = urlTokens.next();
                if (next.equalsIgnoreCase("pipelines")) {
                    blueUrlTokenizer.addPart(UrlPart.DASHBOARD_PIPELINES, next);
                } else if (next.equalsIgnoreCase("organizations") && urlTokens.hasNext()) {
                    blueUrlTokenizer.addPart(UrlPart.ORGANIZATION, urlTokens.next());
                    if (urlTokens.hasNext()) {
                        blueUrlTokenizer.addPart(UrlPart.PIPELINE, BlueUrlTokenizer.urlDecode(urlTokens.next()));
                        if (urlTokens.hasNext()) {
                            next = urlTokens.next();
                            if (next.equalsIgnoreCase("detail")) {
                                blueUrlTokenizer.addPart(UrlPart.PIPELINE_RUN_DETAIL, next);
                                if (urlTokens.hasNext()) {
                                    blueUrlTokenizer.addPart(UrlPart.BRANCH, BlueUrlTokenizer.urlDecode(urlTokens.next()));
                                    if (urlTokens.hasNext()) {
                                        blueUrlTokenizer.addPart(UrlPart.PIPELINE_RUN_DETAIL_ID, BlueUrlTokenizer.urlDecode(urlTokens.next()));
                                        if (urlTokens.hasNext() && PIPELINE_RUN_DETAIL_TABS.contains((next = urlTokens.next()).toLowerCase())) {
                                            blueUrlTokenizer.addPart(UrlPart.PIPELINE_RUN_DETAIL_TAB, next.toLowerCase());
                                        }
                                    }
                                }
                            } else if (PIPELINE_TABS.contains(next.toLowerCase())) {
                                blueUrlTokenizer.addPart(UrlPart.PIPELINE_TAB, next.toLowerCase());
                            }
                        }
                    }
                }
            }
            return blueUrlTokenizer;
        }
        return null;
    }

    private void addPart(@Nonnull UrlPart urlPart, @Nonnull String value) {
        this.urlParts.put(urlPart, value);
        this.lastPart = urlPart;
    }

    public boolean hasPart(@Nonnull UrlPart urlPart) {
        return this.urlParts.containsKey((Object)urlPart);
    }

    @CheckForNull
    public String getPart(@Nonnull UrlPart urlPart) {
        return this.urlParts.get((Object)urlPart);
    }

    @CheckForNull
    public UrlPart getLastPart() {
        return this.lastPart;
    }

    public boolean lastPartIs(@Nonnull UrlPart urlPart) {
        return this.lastPart == urlPart;
    }

    public boolean lastPartIs(@Nonnull UrlPart urlPart, @Nonnull String value) {
        if (this.lastPart == urlPart) {
            return this.getPart(this.lastPart).equals(value);
        }
        return false;
    }

    private static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UnsupportedEncodingException for UTF-8.");
        }
    }

    private static Iterator<String> extractTokens(String url) {
        String[] uncleanedTokens = url.split("/");
        ArrayList<String> cleanedTokens = new ArrayList<String>();
        for (String uncleanedToken : uncleanedTokens) {
            if (uncleanedToken.length() == 0) continue;
            cleanedTokens.add(uncleanedToken);
        }
        return cleanedTokens.iterator();
    }

    public static enum UrlPart {
        DASHBOARD_PIPELINES,
        ORGANIZATION,
        PIPELINE,
        PIPELINE_TAB,
        PIPELINE_RUN_DETAIL,
        BRANCH,
        PIPELINE_RUN_DETAIL_ID,
        PIPELINE_RUN_DETAIL_TAB;

    }
}

