/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import io.jenkins.blueocean.commons.stapler.export.CustomExportedBean;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.FilteringTreePruner;
import io.jenkins.blueocean.commons.stapler.export.Model;
import io.jenkins.blueocean.commons.stapler.export.ModelBuilder;
import io.jenkins.blueocean.commons.stapler.export.NotExportableException;
import io.jenkins.blueocean.commons.stapler.export.Range;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.export.Exported;

public abstract class Property
implements Comparable<Property> {
    public final String name;
    final ModelBuilder owner;
    public final int visibility;
    public final Model parent;
    public final boolean inline;
    public final boolean merge;
    private final boolean skipNull;
    private String[] verboseMap;
    private final Type type;
    static final Set<Class> STRING_TYPES = new HashSet<Class>(Arrays.asList(String.class, URL.class));
    static final Set<Class> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Boolean.class, Short.class, Character.class, Float.class, Double.class));

    Property(Model parent, String name, Type type, Exported exported) {
        this.parent = parent;
        this.owner = parent.parent;
        this.name = exported.name().length() > 1 ? exported.name() : name;
        this.type = type;
        int v = exported.visibility();
        if (v == 0) {
            v = parent.defaultVisibility;
        }
        this.visibility = v;
        this.inline = exported.inline();
        this.merge = exported.merge();
        this.skipNull = exported.skipNull();
        String[] s = exported.verboseMap().split("/");
        this.verboseMap = s.length < 2 ? null : s;
    }

    @Override
    public int compareTo(Property that) {
        return this.name.compareTo(that.name);
    }

    public abstract Type getGenericType();

    public abstract Class getType();

    public abstract String getJavadoc();

    public void writeTo(Object object, TreePruner pruner, DataWriter writer) throws IOException {
        TreePruner child = pruner.accept(object, this);
        if (child == null) {
            return;
        }
        Object d = this.safeGetValue(object);
        if (d == null && this.skipNull) {
            return;
        }
        if (this.merge) {
            if (d != null) {
                Model<?> model = this.owner.get(d.getClass(), this.parent.type, this.name);
                model.writeNestedObjectTo(d, new FilteringTreePruner(this.parent.HAS_PROPERTY_NAME_IN_ANCESTORY, child), writer);
            }
        } else {
            writer.name(this.name);
            this.writeValue(this.type, d, child, writer);
        }
    }

    private Object safeGetValue(Object o) throws IOException {
        try {
            return this.getValue(o);
        }
        catch (IllegalAccessException e) {
            IOException x = new IOException("Failed to write " + this.name);
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            IOException x = new IOException("Failed to write " + this.name);
            x.initCause(e);
            throw x;
        }
    }

    public void writeTo(Object object, int depth, DataWriter writer) throws IOException {
        this.writeTo(object, new TreePruner.ByDepth(depth), writer);
    }

    private void writeValue(Type expected, Object value, TreePruner pruner, DataWriter writer) throws IOException {
        this.writeValue(expected, value, pruner, writer, false);
    }

    private void writeValue(Type expected, Object value, TreePruner pruner, DataWriter writer, boolean skipIfFail) throws IOException {
        Model<?> model;
        if (value == null) {
            writer.valueNull();
            return;
        }
        if (value instanceof CustomExportedBean) {
            this.writeValue(expected, ((CustomExportedBean)value).toExportedObject(), pruner, writer);
            return;
        }
        Class<?> c = value.getClass();
        try {
            model = this.owner.get(c, this.parent.type, this.name);
        }
        catch (NotExportableException ex) {
            if (STRING_TYPES.contains(c)) {
                writer.value(value.toString());
                return;
            }
            if (PRIMITIVE_TYPES.contains(c)) {
                writer.valuePrimitive(value);
                return;
            }
            Class<?> act = c.getComponentType();
            if (act != null) {
                Range r = pruner.getRange();
                writer.startArray();
                if (value instanceof Object[]) {
                    for (Object item : r.apply((Object[])value)) {
                        this.writeValue(act, item, pruner, writer, true);
                    }
                } else {
                    int len = Math.min(r.max, Array.getLength(value));
                    for (int i = r.min; i < len; ++i) {
                        this.writeValue(act, Array.get(value, i), pruner, writer, true);
                    }
                }
                writer.endArray();
                return;
            }
            if (value instanceof Iterable) {
                writer.startArray();
                Type expectedItemType = Types.getTypeArgument((Type)expected, (int)0, null);
                for (Object item : pruner.getRange().apply((Iterable)value)) {
                    this.writeValue(expectedItemType, item, pruner, writer, true);
                }
                writer.endArray();
                return;
            }
            if (value instanceof Map) {
                if (this.verboseMap != null) {
                    writer.startArray();
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        this.writeStartObjectNullType(writer);
                        writer.name(this.verboseMap[0]);
                        this.writeValue(null, e.getKey(), pruner, writer);
                        writer.name(this.verboseMap[1]);
                        this.writeValue(null, e.getValue(), pruner, writer);
                        writer.endObject();
                    }
                    writer.endArray();
                } else {
                    this.writeStartObjectNullType(writer);
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        writer.name(e.getKey().toString());
                        this.writeValue(null, e.getValue(), pruner, writer);
                    }
                    writer.endObject();
                }
                return;
            }
            if (value instanceof Date) {
                writer.valuePrimitive(((Date)value).getTime());
                return;
            }
            if (value instanceof Calendar) {
                writer.valuePrimitive(((Calendar)value).getTimeInMillis());
                return;
            }
            if (value instanceof Enum) {
                writer.value(value.toString());
                return;
            }
            if (skipIfFail) {
                writer.startObject();
                writer.endObject();
                return;
            }
            throw ex;
        }
        try {
            writer.type(expected, value.getClass());
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        writer.startObject();
        model.writeNestedObjectTo(value, pruner, writer);
        writer.endObject();
    }

    private void writeStartObjectNullType(DataWriter writer) throws IOException {
        try {
            writer.type(null, null);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        writer.startObject();
    }

    protected abstract Object getValue(Object var1) throws IllegalAccessException, InvocationTargetException;
}

