/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import io.jenkins.blueocean.commons.stapler.export.MethodHandleFactory;
import io.jenkins.blueocean.commons.stapler.export.Model;
import io.jenkins.blueocean.commons.stapler.export.Property;
import java.beans.Introspector;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.kohsuke.stapler.export.Exported;

final class MethodProperty
extends Property {
    private final MethodHandle handle;
    private final Method method;

    MethodProperty(Model owner, Method m, Exported exported) {
        super(owner, MethodProperty.buildName(m.getName()), m.getGenericReturnType(), exported);
        this.method = m;
        this.handle = MethodHandleFactory.get(this.method);
    }

    private static String buildName(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        }
        return Introspector.decapitalize(name);
    }

    @Override
    public Type getGenericType() {
        return this.method.getGenericReturnType();
    }

    @Override
    public Class getType() {
        return this.method.getReturnType();
    }

    @Override
    public String getJavadoc() {
        return this.parent.getJavadoc().getProperty(this.method.getName() + "()");
    }

    @Override
    protected Object getValue(Object object) throws IllegalAccessException, InvocationTargetException {
        try {
            return this.handle.invoke(object);
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable);
        }
    }
}

