/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler;

import hudson.ExtensionList;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.ExportConfig;
import io.jenkins.blueocean.commons.stapler.export.Flavor;
import io.jenkins.blueocean.commons.stapler.export.Model;
import io.jenkins.blueocean.commons.stapler.export.ModelBuilder;
import io.jenkins.blueocean.commons.stapler.export.NamedPathPruner;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.SecureRequester;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class Export {
    static ModelBuilder MODEL_BUILDER = new ModelBuilder();

    public static void doJson(StaplerRequest req, StaplerResponse rsp, Object bean) throws IOException, ServletException {
        if (req.getParameter("jsonp") == null || Export.permit(req, bean)) {
            rsp.setHeader("X-Jenkins", Jenkins.VERSION);
            rsp.setHeader("X-Jenkins-Session", Jenkins.SESSION_HASH);
            Export.serveExposedBean(req, rsp, bean, req.getParameter("jsonp") == null ? Flavor.JSON : Flavor.JSONP);
        } else {
            rsp.sendError(403, "jsonp forbidden; implement jenkins.security.SecureRequester");
        }
    }

    private static boolean permit(StaplerRequest req, Object bean) {
        for (SecureRequester r : ExtensionList.lookup(SecureRequester.class)) {
            if (!r.permit(req, bean)) continue;
            return true;
        }
        return false;
    }

    private static void serveExposedBean(StaplerRequest req, StaplerResponse resp, Object exposedBean, Flavor flavor) throws ServletException, IOException {
        TreePruner pruner;
        String tree;
        String pad = null;
        resp.setContentType(flavor.contentType);
        Writer w = resp.getCompressedWriter((HttpServletRequest)req);
        if ((flavor == Flavor.JSON || flavor == Flavor.JSONP) && (pad = req.getParameter("jsonp")) != null) {
            w.write(pad + '(');
        }
        if ((tree = req.getParameter("tree")) != null) {
            try {
                pruner = new NamedPathPruner(tree);
            }
            catch (IllegalArgumentException x) {
                throw new ServletException("Malformed tree expression: " + x, (Throwable)x);
            }
        }
        int depth = 0;
        try {
            String s = req.getParameter("depth");
            if (s != null) {
                depth = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            throw new ServletException("Depth parameter must be a number");
        }
        pruner = new TreePruner.ByDepth(1 - depth);
        ExportConfig config = new ExportConfig();
        config.prettyPrint = req.hasParameter("pretty");
        DataWriter dw = flavor.createDataWriter(exposedBean, w, config);
        if (exposedBean instanceof Object[]) {
            dw.startArray();
            for (Object item : (Object[])exposedBean) {
                Export.writeOne(pruner, dw, item);
            }
            dw.endArray();
        } else {
            Export.writeOne(pruner, dw, exposedBean);
        }
        if (pad != null) {
            w.write(41);
        }
        w.close();
    }

    private static void writeOne(TreePruner pruner, DataWriter dw, Object item) throws IOException {
        Model<?> p = MODEL_BUILDER.get(item.getClass());
        p.writeTo(item, pruner, dw);
    }

    private Export() {
    }
}

