/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ErrorMessage {
    public final String message;
    public final int code;
    private final List<Error> errors = new ArrayList<Error>();

    public ErrorMessage(@Nonnull Integer code, @Nonnull String message) {
        this.code = code;
        this.message = message;
    }

    @JsonIgnore
    public ErrorMessage add(Error error) {
        this.errors.add(error);
        return this;
    }

    @JsonProperty(value="errors")
    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        private final String message;
        private final String code;
        private final String field;

        public Error(String field, String code, String message) {
            this.message = message;
            this.code = code;
            this.field = field;
        }

        @JsonProperty(value="message")
        public String getMessage() {
            return this.message;
        }

        @JsonProperty(value="code")
        public String getCode() {
            return this.code;
        }

        @JsonProperty(value="field")
        public String getField() {
            return this.field;
        }

        public static enum ErrorCodes {
            MISSING,
            ALREADY_EXISTS,
            INVALID,
            NOT_FOUND;

        }
    }
}

