/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import javax.annotation.Nonnull;

public class BbCloudBranch
extends BbBranch {
    private final String name;
    private final String commitId;
    private final boolean defaultBranch;

    @JsonCreator
    public BbCloudBranch(@Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="target") Target target) {
        this.name = name;
        this.commitId = target.hash;
        this.defaultBranch = target.repo.getDefaultBranch().equals(name);
    }

    @Override
    public String getLatestCommit() {
        return this.commitId;
    }

    @Override
    public boolean isDefault() {
        return this.defaultBranch;
    }

    @Override
    public String getDisplayId() {
        return this.name;
    }

    public static class Target {
        private final String hash;
        private final BbCloudRepo repo;

        @JsonCreator
        public Target(@Nonnull @JsonProperty(value="hash") String hash, @Nonnull @JsonProperty(value="repository") BbCloudRepo repo) {
            this.hash = hash;
            this.repo = repo;
        }
    }
}

