/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class HttpResponse {
    private final org.apache.http.HttpResponse response;

    public HttpResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    @CheckForNull
    public InputStream getContent() {
        try {
            HttpEntity entity = this.response.getEntity();
            if (this.getStatus() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new ServiceException(this.getStatus(), this.getStatusLine());
            }
            return entity == null ? null : entity.getContent();
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Nonnull
    public String getStatusLine() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @CheckForNull
    public String getHeader(String name) {
        return this.response.getFirstHeader(name).getValue();
    }
}

