/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.HttpRequest;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbUser;
import io.jenkins.blueocean.commons.ServiceException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.HttpResponseException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class BitbucketApi {
    protected final String apiUrl;
    protected final String userName;
    protected final HttpRequest request;

    protected BitbucketApi(@Nonnull String apiUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
        this.apiUrl = BitbucketApi.ensureTrailingSlash(apiUrl);
        this.request = new HttpRequest.HttpRequestBuilder(apiUrl).credentials(credentials).build();
        this.userName = credentials.getUsername();
    }

    @Nonnull
    public BbUser getUser() {
        return this.getUser(this.userName);
    }

    @Nonnull
    public abstract BbUser getUser(@Nonnull String var1);

    @Nonnull
    public abstract BbPage<BbOrg> getOrgs(int var1, int var2);

    @Nonnull
    public abstract BbOrg getOrg(@Nonnull String var1);

    @Nonnull
    public abstract BbRepo getRepo(@Nonnull String var1, String var2);

    @Nonnull
    public abstract BbPage<BbRepo> getRepos(@Nonnull String var1, int var2, int var3);

    @Nonnull
    public abstract String getContent(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4);

    @Nonnull
    public abstract BbSaveContentResponse saveContent(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, @Nonnull String var5, @Nullable String var6, @Nullable String var7, @Nullable String var8);

    public abstract boolean fileExists(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4);

    @CheckForNull
    public abstract BbBranch getBranch(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3);

    @Nonnull
    public abstract BbBranch createBranch(@Nonnull String var1, @Nonnull String var2, Map<String, String> var3);

    @CheckForNull
    public abstract BbBranch getDefaultBranch(@Nonnull String var1, @Nonnull String var2);

    public abstract boolean isEmptyRepo(@Nonnull String var1, @Nonnull String var2);

    protected ServiceException handleException(Exception e) {
        if (e instanceof HttpResponseException) {
            return new ServiceException(((HttpResponseException)e).getStatusCode(), e.getMessage(), (Throwable)e);
        }
        return new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
    }

    protected static String ensureTrailingSlash(String url) {
        if (url.charAt(url.length() - 1) != '/') {
            return url + "/";
        }
        return url;
    }
}

