/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server;

import hudson.Extension;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.AbstractBitbucketScm;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketCredentialUtils;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerEndpointContainer;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import javax.annotation.Nonnull;

public class BitbucketServerScm
extends AbstractBitbucketScm {
    public static final String ID = "bitbucket-server";
    static final String DOMAIN_NAME = "blueocean-bitbucket-server-domain";

    public BitbucketServerScm(Reachable parent) {
        super(parent);
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Override
    @Nonnull
    public String getUri() {
        return this.getApiUrlParameter();
    }

    public ScmServerEndpointContainer getServers() {
        return new BitbucketServerEndpointContainer((Reachable)this);
    }

    @Override
    @Nonnull
    protected String createCredentialId(@Nonnull String apiUrl) {
        return BitbucketCredentialUtils.computeCredentialId(null, ID, apiUrl);
    }

    @Override
    @Nonnull
    protected String getDomainId() {
        return DOMAIN_NAME;
    }

    @Extension
    public static class BbScmFactory
    extends ScmFactory {
        public Scm getScm(String id, Reachable parent) {
            if (id.equals(BitbucketServerScm.ID)) {
                return this.getScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new BitbucketServerScm(parent);
        }
    }
}

