/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import hudson.Extension;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApiFactory;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.HttpRequest;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.HttpResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.Messages;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerProject;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerUser;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class BitbucketServerApi
extends BitbucketApi {
    public static final DefaultArtifactVersion MINIMUM_SUPPORTED_VERSION = new DefaultArtifactVersion("5.2.0");
    private final String baseUrl;
    private final StandardUsernamePasswordCredentials credentials;

    BitbucketServerApi(@Nonnull String hostUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
        super(hostUrl, credentials);
        this.baseUrl = this.apiUrl + "rest/api/1.0/";
        this.credentials = credentials;
    }

    @Nonnull
    public static String getVersion(@Nonnull String apiUrl) {
        try {
            apiUrl = BitbucketServerApi.ensureTrailingSlash(apiUrl);
            HttpRequest request = new HttpRequest.HttpRequestBuilder(apiUrl).build();
            HttpResponse response = request.get(apiUrl + "rest/api/1.0/application-properties");
            int status = response.getStatus();
            if (status >= 301 && status <= 303 || status == 307 || status == 308) {
                String location = response.getHeader("Location");
                String error = String.format("%s is invalid. Bitbucket server sent redirect response", apiUrl);
                if (StringUtils.isNotBlank((String)location)) {
                    URL url = new URL(location);
                    String host = url.getHost();
                    int port = url.getPort();
                    String protocol = url.getProtocol();
                    String baseUrl = protocol + "://" + host + (port == -1 ? "/" : port + "/");
                    error = error + " with location at: " + baseUrl;
                }
                error = error + ". \nPlease use correct Bitbucket Server endpoint.";
                throw new ServiceException(status, error);
            }
            InputStream inputStream = response.getContent();
            Map resp = (Map)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
            String version = (String)resp.get("version");
            if (StringUtils.isBlank((String)version)) {
                throw new ServiceException.PreconditionRequired("Unsupported Bitbucket server, no version information could be determined");
            }
            return version;
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public BbServerUser getUser(@Nonnull String userName) {
        try {
            InputStream inputStream = this.request.get(String.format("%s/%s", this.baseUrl + "users", userName)).getContent();
            return (BbServerUser)JsonConverter.om.readValue(inputStream, BbServerUser.class);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public BbPage<BbOrg> getOrgs(int pageNumber, int pageSize) {
        try {
            if (pageNumber <= 0) {
                pageNumber = 1;
            }
            if (pageSize <= 0) {
                pageSize = 100;
            }
            InputStream inputStream = this.request.get(String.format("%s?start=%s&limit=%s", this.baseUrl + "projects/", this.toStart(pageNumber, pageSize), pageSize)).getContent();
            BbPage page = (BbPage)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbServerPage<BbServerProject>>(){});
            if (pageNumber == 1) {
                BbServerUser user = this.getUser(this.userName);
                ArrayList<BbServerProject> teams = new ArrayList<BbServerProject>();
                teams.add(user.toPersonalProject());
                teams.addAll(page.getValues());
                return new BbServerPage<BbOrg>(page.getStart(), page.getLimit(), page.getSize() + 1, teams, page.isLastPage());
            }
            return page;
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbOrg getOrg(@Nonnull String projectName) {
        try {
            InputStream inputStream = this.request.get(String.format("%s/%s", this.baseUrl + "projects", projectName)).getContent();
            return (BbOrg)JsonConverter.om.readValue(inputStream, BbServerProject.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbPage<BbRepo> getRepos(@Nonnull String projectKey, int pageNumber, int pageSize) {
        try {
            InputStream inputStream = this.request.get(String.format("%s?start=%s&limit=%s", this.baseUrl + "projects/" + projectKey + "/repos/", this.toStart(pageNumber, pageSize), pageSize)).getContent();
            return (BbPage)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbServerPage<BbServerRepo>>(){});
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbRepo getRepo(@Nonnull String orgId, @Nonnull String repoSlug) {
        try {
            InputStream inputStream = this.request.get(String.format("%s/%s/repos/%s/", this.baseUrl + "projects", orgId, repoSlug)).getContent();
            return (BbRepo)JsonConverter.om.readValue(inputStream, BbServerRepo.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public String getContent(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String commitId) {
        ArrayList<String> content = new ArrayList<String>();
        this.getAndBuildContent(orgId, repoSlug, path, commitId, 0, 500, content);
        return Joiner.on((char)'\n').join(content);
    }

    @Override
    @Nonnull
    public BbSaveContentResponse saveContent(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String content, @Nonnull String commitMessage, @Nullable String branch, @Nullable String sourceBranch, @Nullable String commitId) {
        try {
            String version = BitbucketServerApi.getVersion(this.apiUrl);
            if (!BitbucketServerApi.isSupportedVersion(version)) {
                throw new ServiceException.PreconditionRequired(Messages.bbserver_version_validation_error(version, MINIMUM_SUPPORTED_VERSION));
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().addTextBody("content", content).addTextBody("message", commitMessage);
            if (StringUtils.isNotBlank((String)branch)) {
                builder.addTextBody("branch", branch);
            }
            if (StringUtils.isNotBlank((String)sourceBranch)) {
                builder.addTextBody("sourceBranch", sourceBranch);
            }
            if (StringUtils.isNotBlank((String)commitId)) {
                builder.addTextBody("sourceCommitId", commitId);
            }
            HttpEntity entity = builder.build();
            HttpResponse response = this.request.put(String.format("%s/%s/repos/%s/browse/%s", this.baseUrl + "projects", projectKey, repoSlug, path), entity);
            if (commitId != null && response.getStatus() == 409) {
                return new BbServerSaveContentResponse(commitId);
            }
            InputStream inputStream = response.getContent();
            return (BbSaveContentResponse)JsonConverter.om.readValue(inputStream, BbServerSaveContentResponse.class);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean fileExists(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String branch) {
        try {
            HttpResponse response;
            URIBuilder uriBuilder = new URIBuilder(String.format("%s/%s/repos/%s/browse/%s", this.baseUrl + "projects", projectKey, repoSlug, path));
            if (branch != null) {
                uriBuilder.addParameter("at", "refs/heads/" + branch);
            }
            return (response = this.request.head(uriBuilder.build().toString())).getStatus() == 200;
        }
        catch (URISyntaxException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @CheckForNull
    public BbBranch getBranch(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String branch) {
        try {
            URIBuilder uriBuilder = new URIBuilder(String.format("%s/%s/repos/%s/branches/", this.baseUrl + "projects", orgId, repoSlug));
            uriBuilder.addParameter("filterText", branch);
            BbServerPage branches = (BbServerPage)JsonConverter.om.readValue(this.request.get(uriBuilder.build().toString()).getContent(), (TypeReference)new TypeReference<BbServerPage<BbServerBranch>>(){});
            String expectedId = "refs/heads/" + branch;
            for (BbServerBranch b : branches.getValues()) {
                if (!b.getId().equals(expectedId)) continue;
                return b;
            }
            return null;
        }
        catch (IOException | URISyntaxException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbBranch createBranch(@Nonnull String orgId, @Nonnull String repoSlug, Map<String, String> payload) {
        try {
            return (BbBranch)JsonConverter.om.readValue(this.request.post(String.format("%s/%s/repos/%s/branches/", this.baseUrl + "projects", orgId, repoSlug), (HttpEntity)new ByteArrayEntity(JsonConverter.om.writeValueAsBytes(payload), ContentType.APPLICATION_JSON)).getContent(), BbServerBranch.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @CheckForNull
    public BbBranch getDefaultBranch(@Nonnull String orgId, @Nonnull String repoSlug) {
        try {
            HttpResponse response = this.request.get(String.format("%s/%s/repos/%s/branches/default", this.baseUrl + "projects", orgId, repoSlug));
            if (response.getStatus() == 404) {
                return null;
            }
            InputStream inputStream = response.getContent();
            return (BbBranch)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbServerBranch>(){});
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isEmptyRepo(@Nonnull String orgId, @Nonnull String repoSlug) {
        try {
            URIBuilder uriBuilder = new URIBuilder(String.format("%s/%s/repos/%s/branches/default", this.baseUrl + "projects", orgId, repoSlug));
            HttpResponse response = this.request.head(uriBuilder.build().toString());
            return response.getStatus() == 404;
        }
        catch (URISyntaxException e) {
            throw this.handleException(e);
        }
    }

    private void getAndBuildContent(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String commitId, int start, int limit, @Nonnull List<String> lines) {
        try {
            InputStream inputStream = this.request.get(String.format("%s/%s/repos/%s/browse/%s?at=%s&start=%s&limit=%s", this.baseUrl + "projects", projectKey, repoSlug, path, commitId, start, limit)).getContent();
            Map content = (Map)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            List lineMap = (List)content.get("lines");
            this.collectLines(lineMap, lines);
            int size = (Integer)content.get("size");
            if (!((Boolean)content.get("isLastPage")).booleanValue()) {
                this.getAndBuildContent(projectKey, repoSlug, path, commitId, start + size, limit, lines);
            }
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    private void collectLines(List<Map<String, String>> lineMap, List<String> lines) {
        lines.addAll(Lists.transform(lineMap, (Function)new Function<Map<String, String>, String>(){

            @Nullable
            public String apply(@Nullable Map<String, String> input) {
                String text;
                if (input != null && (text = input.get("text")) != null) {
                    return text;
                }
                return null;
            }
        }));
    }

    private void assertDefaultBranch(BbBranch defaultBranch, String projectKey, String repo) {
        if (defaultBranch == null) {
            throw new ServiceException.BadRequestException(String.format("No default branch on project %s, repo %s. Please resubmit request with content.branch", projectKey, repo));
        }
    }

    private int toStart(int pageNumber, int pageSize) {
        int start = pageSize * (pageNumber - 1);
        if (start < 0) {
            start = 0;
        }
        return start;
    }

    public static boolean isSupportedVersion(@Nonnull String version) {
        return new DefaultArtifactVersion(version).compareTo((ArtifactVersion)MINIMUM_SUPPORTED_VERSION) >= 0;
    }

    @Extension
    public static class BitbucketServerApiFactory
    extends BitbucketApiFactory {
        @Override
        public boolean handles(@Nonnull String scmId) {
            return scmId.equals("bitbucket-server");
        }

        @Override
        @Nonnull
        public BitbucketApi create(@Nonnull String apiUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
            return new BitbucketServerApi(apiUrl, credentials);
        }
    }
}

