/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class BbCloudTeam
extends BbOrg {
    private final String teamName;
    private final String displayName;
    private final String avatar;

    @JsonCreator
    public BbCloudTeam(@Nonnull @JsonProperty(value="username") String teamName, @Nonnull @JsonProperty(value="display_name") String displayName, @Nonnull @JsonProperty(value="links") Map<String, Map<String, String>> links) {
        this.teamName = teamName;
        this.displayName = displayName;
        Map<String, String> a = links.get("avatar");
        this.avatar = a != null ? BbCloudTeam.avatar50(a.get("href")) : null;
    }

    public BbCloudTeam(String teamName, String displayName, String avatar) {
        this.teamName = teamName;
        this.displayName = displayName;
        this.avatar = avatar;
    }

    @Override
    public String getKey() {
        return this.teamName;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getAvatar() {
        return this.avatar;
    }

    @Override
    public boolean isPublicProject() {
        return false;
    }

    static String avatar50(String href) {
        if (StringUtils.isBlank((String)href)) {
            return null;
        }
        int i = href.lastIndexOf("/avatar/");
        if (i != -1) {
            return href.substring(0, i) + "/avatar/50/";
        }
        return href;
    }
}

