/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BbCloudPage<T>
extends BbPage<T> {
    private final int pageLength;
    private final int page;
    private final int size;
    private final String next;
    private final List<T> values;

    public BbCloudPage(@JsonProperty(value="pagelen") int pageLength, @JsonProperty(value="page") int page, @JsonProperty(value="size") int size, @Nullable @JsonProperty(value="next") String next, @Nonnull @JsonProperty(value="values") List<T> values) {
        this.pageLength = pageLength;
        this.page = page;
        this.size = size;
        this.next = next;
        this.values = ImmutableList.copyOf(values);
    }

    @Override
    public int getStart() {
        int start = this.pageLength * (this.page - 1);
        if (start < 0) {
            return 0;
        }
        return start;
    }

    @Override
    public int getLimit() {
        return this.pageLength;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public List<T> getValues() {
        return this.values;
    }

    public String getNext() {
        return this.next;
    }

    @Override
    public boolean isLastPage() {
        return this.next == null;
    }
}

