/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApiFactory;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketCredentialUtils;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.JsonBody;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainSpecification;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractBitbucketScm
extends AbstractScm {
    private final Reachable parent;

    public AbstractBitbucketScm(Reachable parent) {
        this.parent = parent;
    }

    public Object getState() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Preconditions.checkNotNull((Object)request, (Object)"Must be called in HTTP request context");
        String apiUrl = request.getParameter("apiUrl");
        ErrorMessage message = new ErrorMessage(Integer.valueOf(400), "Invalid request");
        if (StringUtils.isBlank((String)apiUrl)) {
            message.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "apiUrl is required parameter"));
        }
        try {
            new URL(apiUrl);
        }
        catch (MalformedURLException e) {
            message.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "apiUrl parameter must be a valid URL"));
        }
        if (!message.getErrors().isEmpty()) {
            throw new ServiceException.BadRequestException(message);
        }
        this.validateExistingCredential(apiUrl);
        return super.getState();
    }

    public Link getLink() {
        return this.parent.getLink().rel(this.getId());
    }

    @Nonnull
    public String getUri() {
        return this.getApiUrlParameter();
    }

    public String getCredentialId() {
        String apiUrl = this.getApiUrlParameter();
        String credentialId = this.createCredentialId(apiUrl);
        StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (credential != null) {
            return credentialId;
        }
        return null;
    }

    StandardUsernamePasswordCredentials getCredential(String apiUrl) {
        String credentialId = this.createCredentialId(apiUrl);
        return (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
    }

    public Container<ScmOrganization> getOrganizations() {
        User authenticatedUser = this.getAuthenticatedUser();
        StaplerRequest request = Stapler.getCurrentRequest();
        Preconditions.checkNotNull((Object)request, (Object)"This request must be made in HTTP context");
        String credentialId = BitbucketCredentialUtils.computeCredentialId(AbstractBitbucketScm.getCredentialIdFromRequest((StaplerRequest)request), this.getId(), this.getUri());
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        StandardUsernamePasswordCredentials credential = null;
        if (credentialId == null) {
            errors.add(new ErrorMessage.Error("credentialId", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "Missing credential id. It must be provided either as HTTP header: X-CREDENTIAL-NAME or as query parameter 'credentialId'"));
        } else {
            credential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
            if (credential == null) {
                errors.add(new ErrorMessage.Error("credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), String.format("credentialId: %s not found in user %s's credential store", credentialId, authenticatedUser.getId())));
            }
        }
        String apiUrl = request.getParameter("apiUrl");
        if (StringUtils.isBlank((String)apiUrl)) {
            errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "apiUrl is required parameter"));
        }
        if (!errors.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to return Bitbucket organizations").addAll(errors));
        }
        apiUrl = AbstractBitbucketScm.normalizeApiUrl(apiUrl);
        BitbucketApiFactory apiFactory = BitbucketApiFactory.resolve(this.getId());
        if (apiFactory == null) {
            throw new ServiceException.UnexpectedErrorException("BitbucketApiFactory to handle apiUrl " + apiUrl + " not found");
        }
        Preconditions.checkNotNull((Object)credential);
        final BitbucketApi api = apiFactory.create(apiUrl, credential);
        return new Container<ScmOrganization>(){

            public ScmOrganization get(String name) {
                return new BitbucketOrg(api.getOrg(name), api, this.getLink());
            }

            public Link getLink() {
                return AbstractBitbucketScm.this.getLink().rel("organizations");
            }

            public Iterator<ScmOrganization> iterator() {
                return this.iterator(0, 100);
            }

            public Iterator<ScmOrganization> iterator(int start, int limit) {
                if (limit <= 0) {
                    limit = 100;
                }
                if (start < 0) {
                    start = 0;
                }
                int page = start / limit + 1;
                return Lists.transform(api.getOrgs(page, limit).getValues(), (Function)new Function<BbOrg, ScmOrganization>(){

                    @Nullable
                    public ScmOrganization apply(@Nullable BbOrg input) {
                        if (input != null) {
                            return new BitbucketOrg(input, api, this.getLink());
                        }
                        return null;
                    }
                }).iterator();
            }
        };
    }

    public HttpResponse validateAndCreate(@JsonBody JSONObject request) {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("No logged in user found");
        }
        String userName = (String)request.get("userName");
        String password = (String)request.get("password");
        String apiUrl = (String)request.get("apiUrl");
        this.validate(userName, password, apiUrl);
        UsernamePasswordCredentialsImpl credential = new UsernamePasswordCredentialsImpl(CredentialsScope.USER, this.createCredentialId(apiUrl), "Bitbucket server credentials", userName, password);
        this.validateCredential(apiUrl, (StandardUsernamePasswordCredentials)credential);
        StandardUsernamePasswordCredentials bbCredentials = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)this.createCredentialId(apiUrl), StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        try {
            if (bbCredentials == null) {
                CredentialsUtils.createCredentialsInUserStore((Credentials)credential, (User)authenticatedUser, (String)this.getDomainId(), (List)ImmutableList.of((Object)new BlueOceanDomainSpecification()));
            } else {
                CredentialsUtils.updateCredentialsInUserStore((Credentials)bbCredentials, (Credentials)credential, (User)authenticatedUser, (String)this.getDomainId(), (List)ImmutableList.of((Object)new BlueOceanDomainSpecification()));
            }
            return this.createResponse(credential.getId());
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
    }

    private void validate(String userName, String password, String apiUrl) {
        ArrayList<ErrorMessage.Error> errorList = new ArrayList<ErrorMessage.Error>();
        if (StringUtils.isBlank((String)userName)) {
            errorList.add(new ErrorMessage.Error("userName", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "userName is required parameter"));
        }
        if (StringUtils.isBlank((String)password)) {
            errorList.add(new ErrorMessage.Error("password", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "password is required parameter"));
        }
        if (StringUtils.isBlank((String)apiUrl)) {
            errorList.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "apiUrl is required parameter"));
        } else {
            try {
                new URL(apiUrl);
            }
            catch (MalformedURLException e) {
                errorList.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "apiUrl must be a URL: " + e.getMessage()));
            }
        }
        if (!errorList.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Invalid request").addAll(errorList));
        }
    }

    private void validateCredential(String apiUrl, StandardUsernamePasswordCredentials credential) {
        try {
            BitbucketApi api = AbstractBitbucketScm.getApi(apiUrl, this.getId(), credential);
            api.getUser();
        }
        catch (ServiceException ex) {
            if (ex.status == 401) {
                throw new ServiceException.UnauthorizedException(new ErrorMessage(Integer.valueOf(401), "Invalid username / password"));
            }
            throw ex;
        }
    }

    private void validateExistingCredential(@Nonnull String apiUrl) {
        StandardUsernamePasswordCredentials bbCredentials = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)this.createCredentialId(apiUrl), StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (bbCredentials != null) {
            try {
                this.validateCredential(apiUrl, bbCredentials);
            }
            catch (ServiceException ex) {
                if (ex.status == 401) {
                    throw new ServiceException.UnauthorizedException(new ErrorMessage(Integer.valueOf(401), "Existing credential failed authorization"));
                }
                throw ex;
            }
        }
    }

    public static BitbucketApi getApi(String apiUrl, String scmId, StandardUsernamePasswordCredentials credentials) {
        BitbucketApiFactory apiFactory = BitbucketApiFactory.resolve(scmId);
        if (apiFactory == null) {
            throw new ServiceException.UnexpectedErrorException("BitbucketApiFactory to handle apiUrl " + apiUrl + " not found");
        }
        return apiFactory.create(apiUrl, credentials);
    }

    @Nonnull
    protected abstract String createCredentialId(@Nonnull String var1);

    @Nonnull
    protected abstract String getDomainId();

    protected StaplerRequest getStaplerRequest() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Preconditions.checkNotNull((Object)request, (Object)"Must be called in HTTP request context");
        return request;
    }

    @Nonnull
    protected String getApiUrlParameter() {
        return this.getApiUrlParameter(this.getStaplerRequest());
    }

    @Nonnull
    private String getApiUrlParameter(StaplerRequest request) {
        String apiUrl = request.getParameter("apiUrl");
        if (StringUtils.isBlank((String)apiUrl)) {
            throw new ServiceException.BadRequestException("apiUrl is required parameter");
        }
        return AbstractBitbucketScm.normalizeApiUrl(apiUrl);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public static String normalizeApiUrl(@Nonnull String apiUrl) {
        return BitbucketEndpointConfiguration.normalizeServerUrl((String)apiUrl);
    }
}

