/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import hudson.Extension;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApiFactory;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudTeam;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudUser;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbUser;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BitbucketCloudApi
extends BitbucketApi {
    private final String baseUrl;

    protected BitbucketCloudApi(String apiUrl, StandardUsernamePasswordCredentials credentials) {
        super(apiUrl, credentials);
        this.baseUrl = this.apiUrl + "api/2.0/";
    }

    @Override
    @Nonnull
    public BbUser getUser() {
        try {
            InputStream inputStream = Request.Get((String)(this.baseUrl + "user")).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbUser)JsonConverter.om.readValue(inputStream, BbCloudUser.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbUser getUser(@Nonnull String userName) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s", this.baseUrl + "users", userName)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbUser)JsonConverter.om.readValue(inputStream, BbCloudUser.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbPage<BbOrg> getOrgs(int pageNumber, int pageSize) {
        try {
            if (pageNumber <= 0) {
                pageNumber = 1;
            }
            if (pageSize <= 0) {
                pageSize = 100;
            }
            InputStream inputStream = Request.Get((String)String.format("%s&page=%s&pagelen=%s", this.baseUrl + "teams/?role=contributor", pageNumber, pageSize)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            BbPage page = (BbPage)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbCloudPage<BbCloudTeam>>(){});
            if (pageNumber == 1) {
                BbUser user = this.getUser();
                if (page instanceof BbCloudPage) {
                    ArrayList<BbCloudTeam> teams = new ArrayList<BbCloudTeam>();
                    teams.add(new BbCloudTeam(user.getSlug(), user.getDisplayName(), user.getAvatar()));
                    int newSize = page.getSize() + 1;
                    int newPageLength = page.getLimit();
                    if (page.getSize() > page.getLimit()) {
                        ++newPageLength;
                    }
                    teams.addAll(page.getValues());
                    return new BbCloudPage<BbOrg>(newPageLength, pageNumber, newSize, ((BbCloudPage)page).getNext(), teams);
                }
            }
            return page;
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbOrg getOrg(@Nonnull String orgName) {
        try {
            BbUser user = this.getUser();
            if (orgName.equalsIgnoreCase(user.getSlug())) {
                return new BbCloudTeam(user.getSlug(), user.getDisplayName(), user.getAvatar());
            }
            InputStream inputStream = Request.Get((String)String.format("%s/%s", this.baseUrl + "teams", orgName)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbOrg)JsonConverter.om.readValue(inputStream, BbCloudTeam.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbRepo getRepo(@Nonnull String orgId, String repoSlug) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s", this.baseUrl + "repositories/" + orgId, repoSlug)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbRepo)JsonConverter.om.readValue(inputStream, BbCloudRepo.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbPage<BbRepo> getRepos(@Nonnull String orgId, int pageNumber, int pageSize) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s?page=%s&limit=%s", this.baseUrl + "repositories/" + orgId, pageNumber, pageSize)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbPage)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbCloudPage<BbCloudRepo>>(){});
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public String getContent(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String commitId) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s/%s/src/%s/%s", this.baseUrl + "repositories", orgId, repoSlug, commitId, path)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbSaveContentResponse saveContent(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String content, @Nonnull String commitMessage, @Nullable String branch, @Nullable String sourceBranch, @Nullable String commitId) {
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().addTextBody(path, content).addTextBody("message", commitMessage);
            if (StringUtils.isNotBlank((String)branch)) {
                builder.addTextBody("branch", branch);
            }
            if (StringUtils.isNotBlank((String)commitId)) {
                builder.addTextBody("parents", commitId);
            }
            HttpEntity entity = builder.build();
            Response response = Request.Post((String)String.format("%s/%s/%s/src", this.baseUrl + "repositories", orgId, repoSlug)).addHeader("Authorization", this.basicAuthHeaderValue).body(entity).execute();
            HttpResponse resp = response.returnResponse();
            int status = resp.getStatusLine().getStatusCode();
            if (status == 201) {
                String location = resp.getFirstHeader("Location").getValue();
                String cid = location.substring(location.lastIndexOf("/") + 1);
                return new BbCloudSaveContentResponse(cid);
            }
            throw new ServiceException.UnexpectedErrorException("Failed to save file: " + path + " server returned status: " + status);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean fileExists(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String branch) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public BbBranch getBranch(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String branch) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s/refs/branches/%s?fields=target.hash,target.repository.mainbranch.name,target.repository.*,target.repository.owner.*,target.repository.owner.links.avatar.href,name", this.baseUrl + "repositories/" + orgId, repoSlug, branch)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbBranch)JsonConverter.om.readValue(inputStream, BbCloudBranch.class);
        }
        catch (IOException e) {
            if (e instanceof HttpResponseException && ((HttpResponseException)((Object)e)).getStatusCode() == 404) {
                return null;
            }
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbBranch createBranch(@Nonnull String orgId, @Nonnull String repoSlug, Map<String, String> payload) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public BbBranch getDefaultBranch(@Nonnull String orgId, @Nonnull String repoSlug) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s/?fields=mainbranch.*,mainbranch.target.*,mainbranch.target.repository.*,mainbranch.target.repository.mainbranch.name,mainbranch.target.repository.owner.*,mainbranch.target.repository.owner.links.avatar.*", this.baseUrl + "repositories/" + orgId, repoSlug)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            Map resp = (Map)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, BbCloudBranch>>(){});
            return (BbBranch)resp.get("mainbranch");
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean isEmptyRepo(@Nonnull String orgId, @Nonnull String repoSlug) {
        throw new NotImplementedException("Not implemented");
    }

    @Extension
    public static class BitbucketCloudApiFactory
    extends BitbucketApiFactory {
        @Override
        public boolean handles(@Nonnull String apiUrl) {
            StaplerRequest request = Stapler.getCurrentRequest();
            Preconditions.checkNotNull((Object)request);
            String mode = request.getHeader("X_BB_API_TEST_MODE_HEADER");
            boolean isCloudMode = StringUtils.isNotBlank((String)mode) && mode.equals("cloud");
            return isCloudMode || apiUrl.startsWith("https://bitbucket.org") || apiUrl.startsWith("https://api.bitbucket.org");
        }

        @Override
        @Nonnull
        public BitbucketApi create(@Nonnull String apiUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
            return new BitbucketCloudApi(apiUrl, credentials);
        }
    }
}

