/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server;

import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.Messages;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerEndpoint;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpoint;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import java.util.Iterator;
import java.util.LinkedList;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerEndpointContainer
extends ScmServerEndpointContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitbucketServerEndpointContainer.class);
    private final Link self;

    public BitbucketServerEndpointContainer(Reachable parent) {
        this.self = parent.getLink().rel("servers");
    }

    public Link getLink() {
        return this.self;
    }

    public ScmServerEndpoint create(JSONObject request) {
        BitbucketEndpointConfiguration endpointConfiguration;
        String url;
        String name;
        LinkedList<ErrorMessage.Error> errors;
        block16: {
            try {
                Jenkins.get().checkPermission(Item.CREATE);
            }
            catch (Exception e) {
                throw new ServiceException.ForbiddenException("User does not have permission to create repository", (Throwable)e);
            }
            errors = new LinkedList<ErrorMessage.Error>();
            name = (String)request.get("name");
            if (StringUtils.isBlank((String)name)) {
                errors.add(new ErrorMessage.Error("name", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "name is required"));
            }
            url = (String)request.get("apiUrl");
            endpointConfiguration = BitbucketEndpointConfiguration.get();
            if (StringUtils.isBlank((String)url)) {
                errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "apiUrl is required"));
            } else {
                try {
                    String version = BitbucketServerApi.getVersion(url);
                    if (!BitbucketServerApi.isSupportedVersion(version)) {
                        errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), Messages.bbserver_version_validation_error(version, BitbucketServerApi.MINIMUM_SUPPORTED_VERSION)));
                        break block16;
                    }
                    url = BitbucketEndpointConfiguration.normalizeServerUrl((String)url);
                    for (AbstractBitbucketEndpoint endpoint : endpointConfiguration.getEndpoints()) {
                        if (!url.equals(endpoint.getServerUrl())) continue;
                        errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), "apiUrl already exists"));
                        break;
                    }
                }
                catch (ServiceException e) {
                    errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), StringUtils.isBlank((String)e.getMessage()) ? "Invalid URL" : e.getMessage()));
                }
            }
        }
        if (!errors.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to create Bitbucket server endpoint").addAll(errors));
        }
        com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint endpoint = new com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint(name, url, false, null);
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            endpointConfiguration.addEndpoint((AbstractBitbucketEndpoint)endpoint);
        }
        return new BitbucketServerEndpoint((AbstractBitbucketEndpoint)endpoint, (Reachable)this);
    }

    public ScmServerEndpoint get(String id) {
        for (AbstractBitbucketEndpoint endpoint : BitbucketEndpointConfiguration.get().getEndpoints()) {
            if (!id.equals(DigestUtils.sha256Hex((String)endpoint.getServerUrl()))) continue;
            return new BitbucketServerEndpoint(endpoint, (Reachable)this);
        }
        return null;
    }

    public Iterator<ScmServerEndpoint> iterator() {
        BitbucketEndpointConfiguration endpointConfiguration = BitbucketEndpointConfiguration.get();
        UnmodifiableIterator serverEndpoints = Iterators.filter(endpointConfiguration.getEndpoints().iterator(), com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint.class);
        return Iterators.transform((Iterator)serverEndpoints, (Function)new Function<AbstractBitbucketEndpoint, ScmServerEndpoint>(){

            public ScmServerEndpoint apply(AbstractBitbucketEndpoint input) {
                return new BitbucketServerEndpoint(input, (Reachable)BitbucketServerEndpointContainer.this);
            }
        });
    }
}

